/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo.service;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.silverstatistics.volume.model.UserIdCountVolumeCouple;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;

@Provider
@Named(value="quickinfoStatistics")
public class QuickinfoStatistics
implements ComponentStatisticsProvider {
    private PublicationService publicationService = null;

    public Collection<UserIdCountVolumeCouple> getVolume(String spaceId, String componentId) {
        Collection<PublicationDetail> infos = this.getQuickInfos(componentId);
        ArrayList<UserIdCountVolumeCouple> myArrayList = new ArrayList<UserIdCountVolumeCouple>(infos.size());
        for (PublicationDetail detail : infos) {
            UserIdCountVolumeCouple myCouple = new UserIdCountVolumeCouple();
            myCouple.setUserId(detail.getCreatorId());
            myCouple.setCountVolume(1L);
            myArrayList.add(myCouple);
        }
        return myArrayList;
    }

    private PublicationService getPublicationService() {
        if (this.publicationService == null) {
            this.publicationService = PublicationService.get();
        }
        return this.publicationService;
    }

    private Collection<PublicationDetail> getQuickInfos(String componentId) {
        return this.getPublicationService().getOrphanPublications(componentId);
    }
}

