/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.delegate;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.model.GalleryRuntimeException;
import org.silverpeas.components.gallery.model.InternalMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.Streaming;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.date.period.Period;
import org.silverpeas.core.media.streaming.StreamingProvider;
import org.silverpeas.core.media.streaming.StreamingProvidersRegistry;
import org.silverpeas.core.pdc.pdc.model.PdcPosition;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractMediaDataDelegate {
    private final MediaType mediaType;
    private final boolean skipEmptyValues;
    private final String language;
    private HeaderData headerData = null;
    private RecordSet recordSet = null;
    private Form form = null;
    private final List<FileItem> parameters;
    private final String albumId;

    public AbstractMediaDataDelegate(MediaType mediaType, String language, String albumId, List<FileItem> parameters) {
        this(mediaType, language, albumId, parameters, true);
    }

    public AbstractMediaDataDelegate(MediaType mediaType, String language, String albumId, List<FileItem> parameters, boolean skipEmptyValues) {
        this.mediaType = mediaType;
        this.language = language;
        this.skipEmptyValues = skipEmptyValues;
        this.albumId = albumId;
        this.parameters = parameters;
    }

    protected MediaType getMediaType() {
        return this.mediaType;
    }

    public boolean isHeaderData() {
        return this.headerData != null;
    }

    public HeaderData getHeaderData() {
        if (this.headerData == null) {
            this.headerData = new HeaderData();
        }
        return this.headerData;
    }

    public boolean isForm() {
        return this.recordSet != null && this.form != null && this.parameters != null;
    }

    public void setForm(RecordSet recordSet, Form form) {
        this.recordSet = recordSet;
        this.form = form;
    }

    public void updateHeader(Media media) {
        if (!this.skipEmptyValues && media.getType().isStreaming()) {
            Optional streamingProvider = StreamingProvidersRegistry.get().getFromUrl(this.getHeaderData().getHomepageUrl());
            if (streamingProvider.isEmpty()) {
                throw new GalleryRuntimeException("Streaming homepage URL must be defined and supported");
            }
            Streaming streaming = media.getStreaming();
            streaming.setHomepageUrl(this.getHeaderData().getHomepageUrl());
            streaming.setProvider((StreamingProvider)streamingProvider.get());
        }
        this.updateMedia(media);
    }

    private void updateMedia(Media media) {
        if (!this.skipEmptyValues || StringUtil.isDefined((String)this.getHeaderData().getTitle())) {
            media.setTitle(this.getHeaderData().getTitle());
        }
        if (!this.skipEmptyValues || StringUtil.isDefined((String)this.getHeaderData().getDescription())) {
            media.setDescription(this.getHeaderData().getDescription());
        }
        if (!this.skipEmptyValues || StringUtil.isDefined((String)this.getHeaderData().getAuthor())) {
            media.setAuthor(this.getHeaderData().getAuthor());
        }
        if (!this.skipEmptyValues || StringUtil.isDefined((String)this.getHeaderData().getKeyWord())) {
            media.setKeyWord(this.getHeaderData().getKeyWord());
        }
        this.updateMediaVisibilityPeriod(media);
        this.updateMediaDownloadPeriod(media);
    }

    private void updateMediaDownloadPeriod(Media media) {
        if (media instanceof InternalMedia) {
            if (!this.skipEmptyValues || this.getHeaderData().getBeginDownloadDate() != null) {
                ((InternalMedia)media).setDownloadPeriod(Period.getPeriodWithUndefinedIfNull((Date)this.getHeaderData().getBeginDownloadDate(), (Date)((InternalMedia)media).getDownloadPeriod().getEndDate()));
            }
            if (!this.skipEmptyValues || this.getHeaderData().getEndDownloadDate() != null) {
                ((InternalMedia)media).setDownloadPeriod(Period.getPeriodWithUndefinedIfNull((Date)((InternalMedia)media).getDownloadPeriod().getBeginDate(), (Date)this.getHeaderData().getEndDownloadDate()));
            }
            if (!this.skipEmptyValues || this.getHeaderData().isDownloadAuthorized()) {
                ((InternalMedia)media).setDownloadAuthorized(this.getHeaderData().isDownloadAuthorized());
            }
        }
    }

    private void updateMediaVisibilityPeriod(Media media) {
        if (!this.skipEmptyValues || this.getHeaderData().getBeginVisibilityDate() != null) {
            media.setVisibilityPeriod(Period.getPeriodWithUndefinedIfNull((Date)this.getHeaderData().getBeginVisibilityDate(), (Date)media.getVisibilityPeriod().getEndDate()));
        }
        if (!this.skipEmptyValues || this.getHeaderData().getEndVisibilityDate() != null) {
            media.setVisibilityPeriod(Period.getPeriodWithUndefinedIfNull((Date)media.getVisibilityPeriod().getBeginDate(), (Date)this.getHeaderData().getEndVisibilityDate()));
        }
    }

    public void updateForm(String mediaId, PagesContext pagesContext) throws FormException {
        RecordSet set = this.recordSet;
        DataRecord data = set.getRecord(mediaId);
        if (data == null) {
            data = set.getEmptyRecord();
            data.setId(mediaId);
        }
        this.form.update(this.parameters, data, pagesContext);
        set.save(data);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getAlbumId() {
        return this.albumId;
    }

    public FileItem getFileItem() {
        return FileUploadUtil.getFile(this.parameters, (String)"WAIMGVAR0");
    }

    public boolean isSkipEmptyValues() {
        return this.skipEmptyValues;
    }

    public class HeaderData {
        private String homepageUrl = null;
        private String title = null;
        private String description = null;
        private String author = null;
        private String keyWord = null;
        private Date beginVisibilityDate = null;
        private Date endVisibilityDate = null;
        private boolean downloadAuthorized = false;
        private Date beginDownloadDate = null;
        private Date endDownloadDate = null;
        private List<PdcPosition> pdcPositions = null;

        private Date stringToDate(String stringDate) throws ParseException {
            Date date = null;
            if (stringDate != null && StringUtil.isDefined((String)stringDate.trim())) {
                date = DateUtil.stringToDate((String)stringDate, (String)AbstractMediaDataDelegate.this.language);
            }
            return date;
        }

        private String getHomepageUrl() {
            return this.homepageUrl;
        }

        public void setHomepageUrl(String homepageUrl) {
            this.homepageUrl = homepageUrl;
        }

        private String getTitle() {
            return this.title == null ? "" : this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        private String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        private String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        private String getKeyWord() {
            return this.keyWord;
        }

        public void setKeyWord(String keyWord) {
            this.keyWord = keyWord;
        }

        private Date getBeginVisibilityDate() {
            return this.beginVisibilityDate;
        }

        public void setBeginVisibilityDate(String beginVisibilityDate) throws ParseException {
            this.beginVisibilityDate = this.stringToDate(beginVisibilityDate);
        }

        private Date getEndVisibilityDate() {
            return this.endVisibilityDate;
        }

        public void setEndVisibilityDate(String endVisibilityDate) throws ParseException {
            this.endVisibilityDate = this.stringToDate(endVisibilityDate);
        }

        private boolean isDownloadAuthorized() {
            return this.downloadAuthorized;
        }

        public void setDownloadAuthorized(String downloadAuthorized) {
            this.setDownloadAuthorized(StringUtil.getBooleanValue((String)downloadAuthorized));
        }

        public void setDownloadAuthorized(boolean download) {
            this.downloadAuthorized = download;
        }

        private Date getBeginDownloadDate() {
            return this.beginDownloadDate;
        }

        public void setBeginDownloadDate(String beginDownloadDate) throws ParseException {
            this.beginDownloadDate = this.stringToDate(beginDownloadDate);
        }

        private Date getEndDownloadDate() {
            return this.endDownloadDate;
        }

        public void setEndDownloadDate(String endDownloadDate) throws ParseException {
            this.endDownloadDate = this.stringToDate(endDownloadDate);
        }

        public List<PdcPosition> getPdcPositions() {
            return this.pdcPositions;
        }

        public void setPdcPositions(List<PdcPosition> pdcPositions) {
            this.pdcPositions = pdcPositions;
        }
    }
}

