/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.attributeparsers.CssNameConverter;
import com.google.gwt.uibinder.rebind.FieldManager;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldReferenceConverter {
    private static final Pattern BRACES = Pattern.compile("[{]([^}]*)[}]");
    private static final Pattern LEGAL_FIRST_CHAR = Pattern.compile("^[$_a-zA-Z].*");
    private static final String DOTS_AND_PARENS = "[().]";
    private final CssNameConverter cssConverter = new CssNameConverter();
    private final FieldManager fieldManager;

    public static int countFieldReferences(String string) {
        Telltale telltale = new Telltale();
        new FieldReferenceConverter(null).convert(null, string, telltale);
        return telltale.getComputedCount();
    }

    public static String expressionToPath(String expression) {
        String[] chunks = expression.split(DOTS_AND_PARENS);
        StringBuilder b = new StringBuilder();
        for (String chunk : chunks) {
            if (b.length() > 0 && chunk.length() > 0) {
                b.append(".");
            }
            b.append(chunk);
        }
        return b.toString();
    }

    public static boolean hasFieldReferences(String string) {
        return FieldReferenceConverter.countFieldReferences(string) > 0;
    }

    FieldReferenceConverter(FieldManager fieldManager) {
        this.fieldManager = fieldManager;
    }

    public String convert(String in, Delegate delegate) {
        return this.convert(null, in, delegate);
    }

    public String convert(XMLElement source, String in, Delegate delegate) {
        StringBuilder b = new StringBuilder();
        int nextFindStart = 0;
        int lastMatchEnd = 0;
        Matcher m = BRACES.matcher(in);
        while (m.find(nextFindStart)) {
            String fieldReference = m.group(1);
            int start = m.start();
            if (!this.isLegalPreviousCharacter(in, start)) {
                nextFindStart = start + 1;
                continue;
            }
            if (!this.isLegalFirstCharacter(fieldReference)) {
                nextFindStart = start + 2;
                continue;
            }
            String precedingFragment = in.substring(lastMatchEnd, start);
            precedingFragment = this.handleFragment(precedingFragment, delegate);
            b.append(precedingFragment);
            if (this.fieldManager != null) {
                this.fieldManager.registerFieldReference(source, fieldReference, delegate.getTypes());
            }
            fieldReference = this.expandDots(fieldReference);
            b.append(delegate.handleReference(fieldReference));
            nextFindStart = lastMatchEnd = m.end();
        }
        b.append(this.handleFragment(in.substring(lastMatchEnd), delegate));
        return b.toString();
    }

    private String expandDots(String value) {
        StringBuilder b = new StringBuilder();
        String[] segments = value.split("[.]");
        for (int i = 0; i < segments.length; ++i) {
            String segment = this.cssConverter.convertName(segments[i]);
            if (this.fieldManager != null && i == 0) {
                segment = this.fieldManager.convertFieldToGetter(segment);
            }
            if (b.length() == 0) {
                b.append(segment);
                continue;
            }
            b.append(".").append(segment).append("()");
        }
        return b.toString();
    }

    private String handleFragment(String fragment, Delegate delegate) {
        fragment = fragment.replace("\\{", "{");
        return delegate.handleFragment(fragment);
    }

    private boolean isLegalFirstCharacter(String fieldReference) {
        return LEGAL_FIRST_CHAR.matcher(fieldReference).matches();
    }

    private boolean isLegalPreviousCharacter(String in, int start) {
        if (start < 1) {
            return true;
        }
        char previousChar = in.charAt(start - 1);
        return previousChar != '{' && previousChar != '\\';
    }

    private static final class Telltale
    implements Delegate {
        private int computedCount;

        private Telltale() {
        }

        public int getComputedCount() {
            return this.computedCount;
        }

        @Override
        public JType[] getTypes() {
            return new JType[0];
        }

        @Override
        public String handleFragment(String fragment) {
            return fragment;
        }

        @Override
        public String handleReference(String reference) {
            ++this.computedCount;
            return reference;
        }
    }

    static interface Delegate {
        public JType[] getTypes();

        public String handleFragment(String var1) throws IllegalFieldReferenceException;

        public String handleReference(String var1) throws IllegalFieldReferenceException;
    }

    public static class IllegalFieldReferenceException
    extends RuntimeException {
    }
}

