/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.AccessControlValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class AccessControlValidatorProvider
extends ValidatorProvider {
    private final ProviderCtx providerCtx;

    public AccessControlValidatorProvider(@NotNull ProviderCtx providerCtx) {
        this.providerCtx = providerCtx;
    }

    @NotNull
    public Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        RestrictionProvider restrictionProvider = this.getConfig(AuthorizationConfiguration.class).getRestrictionProvider();
        Root root = this.providerCtx.getRootProvider().createReadOnlyRoot(before);
        PrivilegeManager privilegeManager = this.getConfig(PrivilegeConfiguration.class).getPrivilegeManager(root, NamePathMapper.DEFAULT);
        PrivilegeBitsProvider privilegeBitsProvider = new PrivilegeBitsProvider(root);
        return new AccessControlValidator(after, privilegeManager, privilegeBitsProvider, restrictionProvider, this.providerCtx);
    }

    private <T> T getConfig(Class<T> configClass) {
        return (T)this.providerCtx.getSecurityProvider().getConfiguration(configClass);
    }
}

