/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitorAdapter;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.NotNull;

public class MetricsRemoteStoreMonitor
extends RemoteStoreMonitorAdapter {
    public static final String REQUEST_COUNT = "REQUEST_COUNT";
    public static final String REQUEST_ERROR = "REQUEST_ERROR";
    public static final String REQUEST_DURATION = "REQUEST_DURATION";
    private final CounterStats requestCountStats;
    private final CounterStats requestErrorStats;
    private final TimerStats requestDurationStats;

    public MetricsRemoteStoreMonitor(@NotNull StatisticsProvider statisticsProvider) {
        this.requestCountStats = statisticsProvider.getCounterStats(REQUEST_COUNT, StatsOptions.DEFAULT);
        this.requestErrorStats = statisticsProvider.getCounterStats(REQUEST_ERROR, StatsOptions.DEFAULT);
        this.requestDurationStats = statisticsProvider.getTimer(REQUEST_DURATION, StatsOptions.METRICS_ONLY);
    }

    @Override
    public void requestCount() {
        this.requestCountStats.inc();
    }

    @Override
    public void requestError() {
        this.requestErrorStats.inc();
    }

    @Override
    public void requestDuration(long duration, TimeUnit timeUnit) {
        this.requestDurationStats.update(duration, timeUnit);
    }
}

