/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.jetbrains.annotations.NotNull;

class Record {
    private final SegmentId segmentId;
    private final int recordNumber;

    static boolean fastEquals(Object a, Object b) {
        return a instanceof Record && Record.fastEquals((Record)a, b);
    }

    private static boolean fastEquals(@NotNull Record a, Object b) {
        return b instanceof Record && Record.fastEquals(a, (Record)b);
    }

    private static boolean fastEquals(@NotNull Record a, @NotNull Record b) {
        return a == b || a.recordNumber == b.recordNumber && a.segmentId.equals(b.segmentId);
    }

    protected Record(@NotNull RecordId id) {
        this(id.getSegmentId(), id.getRecordNumber());
    }

    protected Record(@NotNull SegmentId segmentId, int recordNumber) {
        this.segmentId = segmentId;
        this.recordNumber = recordNumber;
    }

    protected Segment getSegment() {
        return this.segmentId.getSegment();
    }

    protected int getRecordNumber() {
        return this.recordNumber;
    }

    public RecordId getRecordId() {
        return new RecordId(this.segmentId, this.recordNumber);
    }

    @NotNull
    public GCGeneration getGcGeneration() {
        return this.segmentId.getGcGeneration();
    }

    public boolean equals(Object that) {
        return Record.fastEquals(this, that);
    }

    public int hashCode() {
        return this.segmentId.hashCode() ^ this.recordNumber;
    }

    public String toString() {
        return this.getRecordId().toString();
    }
}

