/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.Throttler;
import org.apache.jackrabbit.oak.plugins.document.ThrottlingStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlingDocumentStoreWrapper
implements DocumentStore {
    private static final Logger LOG = LoggerFactory.getLogger(ThrottlingDocumentStoreWrapper.class);
    private volatile int lastLogTime = 0;
    @NotNull
    private final DocumentStore store;
    @NotNull
    private final ThrottlingStatsCollector throttlingStatsCollector;

    public ThrottlingDocumentStoreWrapper(@NotNull DocumentStore store, @NotNull ThrottlingStatsCollector throttlingStatsCollector) {
        this.store = store;
        this.throttlingStatsCollector = throttlingStatsCollector;
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String key) {
        return this.store.find(collection, key);
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String key, int maxCacheAge) {
        return this.store.find(collection, key, maxCacheAge);
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        return this.store.query(collection, fromKey, toKey, limit);
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        return this.store.query(collection, fromKey, toKey, indexedProperty, startValue, limit);
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit, List<String> projection) throws DocumentStoreException {
        return this.store.query(collection, fromKey, toKey, indexedProperty, startValue, limit, projection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void remove(Collection<T> collection, String key) {
        long throttlingTime = this.performThrottling(collection);
        try {
            this.store.remove(collection, key);
        }
        finally {
            this.throttlingStatsCollector.doneRemove(TimeUnit.MILLISECONDS.toNanos(throttlingTime), collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        long throttlingTime = this.performThrottling(collection);
        try {
            this.store.remove(collection, keys);
        }
        finally {
            this.throttlingStatsCollector.doneRemove(TimeUnit.MILLISECONDS.toNanos(throttlingTime), collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> int remove(Collection<T> collection, Map<String, Long> toRemove) {
        long throttlingTime = this.performThrottling(collection);
        int count = 0;
        try {
            count = this.store.remove(collection, toRemove);
        }
        finally {
            this.throttlingStatsCollector.doneRemove(TimeUnit.MILLISECONDS.toNanos(throttlingTime), collection);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> int remove(Collection<T> collection, String indexedProperty, long startValue, long endValue) throws DocumentStoreException {
        long throttlingTime = this.performThrottling(collection);
        int count = 0;
        try {
            count = this.store.remove(collection, indexedProperty, startValue, endValue);
        }
        finally {
            this.throttlingStatsCollector.doneRemove(TimeUnit.MILLISECONDS.toNanos(throttlingTime), collection);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        long throttlingTime = this.performThrottling(collection);
        boolean isSuccess = false;
        try {
            isSuccess = this.store.create(collection, updateOps);
        }
        finally {
            this.throttlingStatsCollector.doneCreate(TimeUnit.MILLISECONDS.toNanos(throttlingTime), collection, updateOps.stream().map(UpdateOp::getId).collect(Collectors.toList()), isSuccess);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) {
        String string;
        long l;
        long throttlingTime = this.performThrottling(collection);
        T oldDoc = null;
        try {
            oldDoc = this.store.createOrUpdate(collection, update);
            l = TimeUnit.MILLISECONDS.toNanos(throttlingTime);
            string = update.getId();
        }
        catch (Throwable throwable) {
            this.throttlingStatsCollector.doneFindAndModify(TimeUnit.MILLISECONDS.toNanos(throttlingTime), collection, update.getId(), Objects.isNull(oldDoc) && update.isNew(), true, 0);
            throw throwable;
        }
        this.throttlingStatsCollector.doneFindAndModify(l, collection, string, Objects.isNull(oldDoc) && update.isNew(), true, 0);
        return oldDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> List<T> createOrUpdate(Collection<T> collection, List<UpdateOp> updateOps) {
        long throttlingTime = this.performThrottling(collection);
        List<T> results = null;
        try {
            results = this.store.createOrUpdate(collection, updateOps);
        }
        finally {
            this.throttlingStatsCollector.doneCreateOrUpdate(TimeUnit.MILLISECONDS.toNanos(throttlingTime), collection, updateOps.stream().map(UpdateOp::getId).collect(Collectors.toList()));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) {
        long throttlingTime = this.performThrottling(collection);
        T oldDoc = null;
        try {
            oldDoc = this.store.findAndUpdate(collection, update);
        }
        finally {
            this.throttlingStatsCollector.doneFindAndModify(TimeUnit.MILLISECONDS.toNanos(throttlingTime), collection, update.getId(), false, true, 0);
        }
        return oldDoc;
    }

    @Override
    public CacheInvalidationStats invalidateCache() {
        return this.store.invalidateCache();
    }

    @Override
    public CacheInvalidationStats invalidateCache(Iterable<String> keys) {
        return this.store.invalidateCache(keys);
    }

    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String key) {
        this.store.invalidateCache(collection, key);
    }

    @Override
    public void dispose() {
        this.store.dispose();
    }

    @Override
    public <T extends Document> T getIfCached(Collection<T> collection, String key) {
        return this.store.getIfCached(collection, key);
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
        this.store.setReadWriteMode(readWriteMode);
    }

    @Override
    public Iterable<CacheStats> getCacheStats() {
        return this.store.getCacheStats();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.store.getMetadata();
    }

    @Override
    @NotNull
    public Map<String, String> getStats() {
        return this.store.getStats();
    }

    @Override
    public long determineServerTimeDifferenceMillis() {
        return this.store.determineServerTimeDifferenceMillis();
    }

    @Override
    public int getNodeNameLimit() {
        return this.store.getNodeNameLimit();
    }

    @Override
    public Throttler throttler() {
        return this.store.throttler();
    }

    private <T extends Document> long performThrottling(Collection<T> collection) {
        if (Collection.CLUSTER_NODES == collection) {
            return 0L;
        }
        Throttler throttler = this.throttler();
        long throttleTime = throttler.throttlingTime();
        if (throttleTime == 0L) {
            return throttleTime;
        }
        try {
            int currentDecaSecond = (int)(System.currentTimeMillis() / 10000L);
            if (currentDecaSecond > this.lastLogTime) {
                this.lastLogTime = currentDecaSecond;
                LOG.warn("Throttling the system for {} ms for {} collection", (Object)throttleTime, collection);
            }
            Thread.sleep(throttleTime);
        }
        catch (InterruptedException e) {
            LOG.error("Error while throttling", (Throwable)e);
        }
        return throttleTime;
    }
}

