/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.util.BiStatsConsumer;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.TimerStats;

public final class RemoveMetricUpdater {
    private final MeterStats removeNodes;
    private final TimerStats removeNodesTimer;

    public RemoveMetricUpdater(MeterStats removeNodes, TimerStats removeNodesTimer) {
        this.removeNodes = removeNodes;
        this.removeNodesTimer = removeNodesTimer;
    }

    public void update(Collection<? extends Document> collection, int removeCount, long timeTakenNanos, BiPredicate<Collection<? extends Document>, Integer> isNodesCollectionUpdated, BiStatsConsumer removeBiStatsConsumer) {
        Objects.requireNonNull(isNodesCollectionUpdated);
        Objects.requireNonNull(removeBiStatsConsumer);
        if (isNodesCollectionUpdated.negate().test(collection, removeCount)) {
            return;
        }
        removeBiStatsConsumer.accept(this.removeNodes, this.removeNodesTimer, removeCount, timeTakenNanos);
    }
}

