/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.Nullable;

final class LastRevs
implements Iterable<Revision> {
    private final Map<Integer, Revision> revs;
    private final RevisionVector readRevision;
    private final Branch branch;
    private Revision branchRev;

    LastRevs(RevisionVector readRevision) {
        this(Collections.emptyMap(), readRevision, null);
    }

    LastRevs(Map<Integer, Revision> revs, RevisionVector readRevision, Branch branch) {
        this.revs = new HashMap<Integer, Revision>(revs);
        this.readRevision = readRevision;
        this.branch = branch;
    }

    void update(@Nullable Revision rev) {
        if (rev == null) {
            return;
        }
        Revision r = this.revs.get(rev.getClusterId());
        if (r == null || rev.compareRevisionTime(r) > 0) {
            this.revs.put(rev.getClusterId(), rev);
        }
    }

    void updateBranch(@Nullable Revision rev) {
        if (rev == null) {
            return;
        }
        rev = rev.asBranchRevision();
        if (this.branch != null && this.branch.containsCommit(rev) && this.readRevision.getBranchRevision().compareRevisionTime(rev) >= 0) {
            this.branchRev = Utils.max(this.branchRev, rev);
        }
    }

    @Nullable
    Revision getBranchRevision() {
        return this.branchRev;
    }

    @Override
    public Iterator<Revision> iterator() {
        return this.revs.values().iterator();
    }
}

