/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.constraint;

import java.util.function.Predicate;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.core.GuavaDeprecation;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.BinaryConstraint;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.BooleanConstraint;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.DateConstraint;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.DecimalConstraint;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.DoubleConstraint;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.LongConstraint;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.NameConstraint;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.PathConstraint;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.ReferenceConstraint;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.StringConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Constraints {
    private static final Logger log = LoggerFactory.getLogger(Constraints.class);

    private Constraints() {
    }

    public static Predicate<Value> asPredicate(int type, String constraint) {
        switch (type) {
            case 1: {
                return new StringConstraint(constraint);
            }
            case 2: {
                return new BinaryConstraint(constraint);
            }
            case 3: {
                return new LongConstraint(constraint);
            }
            case 4: {
                return new DoubleConstraint(constraint);
            }
            case 5: {
                return new DateConstraint(constraint);
            }
            case 6: {
                return new BooleanConstraint(constraint);
            }
            case 7: {
                return new NameConstraint(constraint);
            }
            case 8: {
                return new PathConstraint(constraint);
            }
            case 9: {
                return new ReferenceConstraint(constraint);
            }
            case 10: {
                return new ReferenceConstraint(constraint);
            }
            case 11: {
                return new StringConstraint(constraint);
            }
            case 12: {
                return new DecimalConstraint(constraint);
            }
        }
        String msg = "Invalid property type: " + type;
        log.warn(msg);
        throw new IllegalArgumentException(msg);
    }

    @Deprecated(since="1.26.0", forRemoval=true)
    public static com.google.common.base.Predicate<Value> valueConstraint(int type, String constraint) {
        GuavaDeprecation.handleCall("OAK-8874");
        return (com.google.common.base.Predicate)Constraints.asPredicate(type, constraint);
    }
}

