/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadResponse;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyHeadReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetHeadRequestHandler
extends SimpleChannelInboundHandler<GetHeadRequest> {
    private static final Logger log = LoggerFactory.getLogger(GetHeadRequest.class);
    private final StandbyHeadReader reader;

    GetHeadRequestHandler(StandbyHeadReader reader) {
        this.reader = reader;
    }

    protected void channelRead0(ChannelHandlerContext ctx, GetHeadRequest msg) throws Exception {
        log.debug("Reading head for client {}", (Object)msg.getClientId());
        String id = this.reader.readHeadRecordId();
        if (id == null) {
            log.debug("Head not found, discarding request from client {}", (Object)msg.getClientId());
            return;
        }
        ctx.writeAndFlush((Object)new GetHeadResponse(msg.getClientId(), id));
    }
}

