/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;

public class LocalManifestFile
implements ManifestFile {
    private final File file;

    public LocalManifestFile(File parent, String name) {
        this(new File(parent, name));
    }

    public LocalManifestFile(File file) {
        this.file = file;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public Properties load() throws IOException {
        Properties properties = new Properties();
        try (FileReader r = new FileReader(this.file);){
            properties.load(r);
        }
        return properties;
    }

    @Override
    public void save(Properties properties) throws IOException {
        try (FileWriter w = new FileWriter(this.file);){
            properties.store(w, null);
        }
    }
}

