/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.scheduleevent.service.model.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.silverpeas.components.scheduleevent.service.model.ScheduleEventBean;
import org.silverpeas.components.scheduleevent.service.model.beans.Contributor;
import org.silverpeas.components.scheduleevent.service.model.beans.DateOption;
import org.silverpeas.components.scheduleevent.service.model.beans.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.SilverpeasToolContent;

@Entity
@Table(name="sc_scheduleevent_list")
@NamedQueries(value={@NamedQuery(name="findByAuthor", query="from ScheduleEvent where author = :authorId"), @NamedQuery(name="findByContributor", query="select e from Contributor c join c.scheduleEvent e where c.userId = :contributorId")})
public class ScheduleEvent
implements SilverpeasToolContent,
ScheduleEventBean,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "ScheduleEvent";
    @Id
    private String id;
    private String title;
    private String description;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Column(name="creatorid")
    private int author;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="scheduleeventid", nullable=false)
    @OrderBy(value="day, hour ASC")
    private final Set<DateOption> dates = new TreeSet<DateOption>();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, mappedBy="scheduleEvent")
    private final Set<Contributor> contributors = new HashSet<Contributor>();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, mappedBy="scheduleEvent")
    private final Set<Response> responses = new HashSet<Response>();
    private int status;

    @PrePersist
    protected void setUpId() {
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public Date getLastUpdateDate() {
        return this.getCreationDate();
    }

    @Override
    public int getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(int author) {
        this.author = author;
    }

    @Override
    public Set<DateOption> getDates() {
        return this.dates;
    }

    @Override
    public Set<Contributor> getContributors() {
        return this.contributors;
    }

    @Override
    public Set<Response> getResponses() {
        return this.responses;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    public String getComponentInstanceId() {
        return "scheduleEventTool";
    }

    public User getCreator() {
        return User.getById((String)Integer.toString(this.getAuthor()));
    }

    public String getContributionType() {
        return TYPE;
    }

    public boolean canBeAccessedBy(User user) {
        boolean isContributor = user.getId().equals(String.valueOf(this.getAuthor()));
        Iterator<Contributor> it = this.getContributors().iterator();
        while (it.hasNext() && !isContributor) {
            isContributor = user.getId().equals(String.valueOf(it.next().getUserId()));
        }
        return isContributor;
    }

    public static String getResourceType() {
        return TYPE;
    }

    public String getURL() {
        return "/Rscheduleevent/jsp/Detail?scheduleEventId=" + this.getId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduleEvent other = (ScheduleEvent)obj;
        if (this.id == null) {
            return other.id == null;
        }
        return this.id.equals(other.id);
    }
}

