/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silverpeas.components.questionreply.model.Question;

public class QuestionRegexpComparator
implements Comparator<Question> {
    private static QuestionRegexpComparator instance;
    private Pattern pattern = Pattern.compile("([0-9\\.]*)\\s?-\\s?.*");
    private Pattern numberPattern = Pattern.compile("[0-9]+");

    private QuestionRegexpComparator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuestionRegexpComparator getInstance() {
        Class<QuestionRegexpComparator> clazz = QuestionRegexpComparator.class;
        synchronized (QuestionRegexpComparator.class) {
            if (instance == null) {
                instance = new QuestionRegexpComparator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public int compare(Question question1, Question question2) {
        int result = -1;
        if (question1 == question2) {
            result = 0;
        } else if (question1 == null || question1.getTitle() == null) {
            result = -1;
        } else if (question2 == null || question2.getTitle() == null) {
            result = 1;
        } else {
            List<Integer> numbersQuestion1 = this.extractNumber(question1.getTitle());
            List<Integer> numbersQuestion2 = this.extractNumber(question2.getTitle());
            result = numbersQuestion1.isEmpty() || numbersQuestion2.isEmpty() ? question1.getTitle().compareTo(question2.getTitle()) : (numbersQuestion1.size() > numbersQuestion2.size() ? this.compareNumbers(numbersQuestion1, numbersQuestion2) : -1 * this.compareNumbers(numbersQuestion2, numbersQuestion1));
        }
        return result;
    }

    protected List<Integer> extractNumber(String label) {
        Matcher matcher = this.pattern.matcher(label);
        ArrayList<Integer> result = new ArrayList<Integer>();
        String prefix = null;
        if (matcher.matches()) {
            prefix = matcher.group(1);
        }
        if (prefix != null) {
            matcher = this.numberPattern.matcher(prefix);
            while (matcher.find()) {
                String number = prefix.substring(matcher.start(), matcher.end());
                result.add(Integer.valueOf(number));
            }
        }
        return result;
    }

    protected int compareNumbers(List<Integer> bigList, List<Integer> smallList) {
        for (int i = 0; i < smallList.size(); ++i) {
            int value2;
            int value1 = bigList.get(i);
            if (value1 == (value2 = smallList.get(i).intValue())) continue;
            return value1 - value2;
        }
        return bigList.size() - smallList.size();
    }
}

