/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.silverpeas.components.datawarning.DataWarningDBDriver;
import org.silverpeas.components.datawarning.DataWarningDBDrivers;
import org.silverpeas.components.datawarning.DataWarningException;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBean;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

public class DataWarning
extends SilverpeasBean {
    private static final long serialVersionUID = 8814573887371294333L;
    public static final int INCONDITIONAL_QUERY = 0;
    public static final int TRIGGER_ANALYSIS = 1;
    private String description;
    private String jdbcDriverName;
    private String login;
    private String pwd;
    private int rowLimit;
    private String instanceId;
    private int analysisType = 0;

    public DataWarning copy() {
        DataWarning newOne;
        try {
            newOne = (DataWarning)((Object)super.clone());
        }
        catch (CloneNotSupportedException e) {
            SilverLogger.getLogger((Object)((Object)this)).silent((Throwable)e);
            newOne = new DataWarning();
        }
        newOne.description = this.description;
        newOne.jdbcDriverName = this.jdbcDriverName;
        newOne.login = this.login;
        newOne.pwd = this.pwd;
        newOne.rowLimit = this.rowLimit;
        newOne.instanceId = this.instanceId;
        newOne.analysisType = this.analysisType;
        newOne.setPK(this.getPK());
        return newOne;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.getNonNullString(this.description);
    }

    public void setJdbcDriverName(String jdbcDriverName) {
        this.jdbcDriverName = jdbcDriverName;
    }

    public String getJdbcDriverName() {
        return this.jdbcDriverName;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogin() {
        return this.getNonNullString(this.login);
    }

    public void setPwd(String password) {
        this.pwd = password;
    }

    public String getPwd() {
        return this.getNonNullString(this.pwd);
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setAnalysisType(int analysisType) {
        this.analysisType = analysisType;
    }

    public int getAnalysisType() {
        return this.analysisType;
    }

    @NonNull
    protected String getTableName() {
        return "SC_DataWarning";
    }

    public Connection openConnection() throws DataWarningException {
        Connection con;
        DataWarningDBDrivers dataWarningDBDrivers = new DataWarningDBDrivers();
        DataWarningDBDriver dbDriver = dataWarningDBDrivers.getDBDriver(this.jdbcDriverName);
        try {
            Class.forName(dbDriver.getClassName());
            con = DriverManager.getConnection(dbDriver.getJdbcUrl(), this.login, this.pwd);
        }
        catch (Exception e) {
            throw new DataWarningException(e);
        }
        return con;
    }

    public void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            }
        }
    }

    public String[] getAllTableNames() throws DataWarningException {
        String[] retour;
        Connection con = this.openConnection();
        ResultSet tablesRs = null;
        try {
            DatabaseMetaData dbMetaData = con.getMetaData();
            tablesRs = dbMetaData.getTables(null, null, null, null);
            ArrayList<String> tables = new ArrayList<String>();
            while (tablesRs.next()) {
                tables.add(tablesRs.getString("TABLE_NAME"));
            }
            retour = new String[tables.size()];
            for (int i = 0; i < tables.size(); ++i) {
                retour[i] = (String)tables.get(i);
            }
        }
        catch (Exception e) {
            try {
                throw new DataWarningException(e);
            }
            catch (Throwable throwable) {
                DBUtil.close(tablesRs);
                this.closeConnection(con);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)tablesRs);
        this.closeConnection(con);
        return retour;
    }

    public String[] getColumnNames(String tableName) throws DataWarningException {
        String[] retour;
        Connection con = this.openConnection();
        ResultSet colonnesRs = null;
        try {
            DatabaseMetaData dbMetaData = con.getMetaData();
            colonnesRs = dbMetaData.getColumns(null, null, tableName, null);
            ArrayList<String> colonnes = new ArrayList<String>();
            while (colonnesRs.next()) {
                colonnes.add(colonnesRs.getString("COLUMN_NAME"));
            }
            retour = new String[colonnes.size()];
            for (int i = 0; i < colonnes.size(); ++i) {
                retour[i] = (String)colonnes.get(i);
            }
        }
        catch (Exception e) {
            try {
                throw new DataWarningException(e);
            }
            catch (Throwable throwable) {
                DBUtil.close(colonnesRs);
                this.closeConnection(con);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)colonnesRs);
        this.closeConnection(con);
        return retour;
    }
}

