/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.notification.user;

import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.SpaceProfile;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.core.util.URLUtil;

public abstract class AbstractCommunityUserNotificationBuilder
extends AbstractTemplateUserNotificationBuilder<CommunityOfUsers> {
    private final MemoizedSupplier<SpaceInst> communitySpace = new MemoizedSupplier(() -> OrganizationController.get().getSpaceInstById(((CommunityOfUsers)((Object)((Object)this.getResource()))).getSpaceId()));

    public AbstractCommunityUserNotificationBuilder(CommunityOfUsers resource) {
        super((Object)resource);
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.components.community.multilang.communityBundle";
    }

    protected String getTemplatePath() {
        return "community";
    }

    protected NotifAction getAction() {
        return NotifAction.REPORT;
    }

    protected String getComponentInstanceId() {
        return ((CommunityOfUsers)((Object)this.getResource())).getComponentInstanceId();
    }

    protected String getSender() {
        return User.getSystemUser().getId();
    }

    protected SpaceInst getSpace() {
        return (SpaceInst)this.communitySpace.get();
    }

    protected void performNotificationResource(String language, CommunityOfUsers resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(this.getSpace().getName(language));
    }

    protected void performTemplateData(String language, CommunityOfUsers resource, SilverpeasTemplate template) {
        String title = this.getTitle();
        this.getNotificationMetaData().addLanguage(language, title, "");
        template.setAttribute("spaceName", (Object)this.getSpace().getName(language));
    }

    protected boolean isSendImmediately() {
        return true;
    }

    protected String getResourceURL(CommunityOfUsers resource) {
        return URLUtil.getSimpleURL((int)URLUtil.Permalink.SPACE.getType(), (String)resource.getSpaceId(), (boolean)false);
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "community.notifSpaceLinkLabel";
    }

    protected SpaceProfile getSpaceManagerProfile() {
        return OrganizationController.get().getSpaceProfile(((CommunityOfUsers)((Object)this.getResource())).getSpaceId(), SilverpeasRole.MANAGER);
    }
}

