/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.suggestionbox.model;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.Vetoed;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.components.suggestionbox.model.Suggestion;
import org.silverpeas.components.suggestionbox.model.SuggestionBox;
import org.silverpeas.components.suggestionbox.model.SuggestionCriteria;
import org.silverpeas.components.suggestionbox.notification.SuggestionBoxSubscriptionUserNotification;
import org.silverpeas.components.suggestionbox.notification.SuggestionPendingValidationUserNotification;
import org.silverpeas.components.suggestionbox.notification.SuggestionValidationUserNotification;
import org.silverpeas.components.suggestionbox.repository.SuggestionRepository;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.contribution.attachment.model.Attachments;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionValidation;
import org.silverpeas.core.io.upload.UploadedFile;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.persistence.Transaction;

@Vetoed
public class SuggestionCollection
implements Collection<Suggestion> {
    private SuggestionBox suggestionBox;

    protected SuggestionCollection(SuggestionBox suggestionBox) {
        this.suggestionBox = suggestionBox;
    }

    @Override
    public int size() {
        SuggestionBox actual = SuggestionBox.getByComponentInstanceId(this.suggestionBox.getComponentInstanceId());
        return actual.persistedSuggestions().size();
    }

    @Override
    public boolean isEmpty() {
        SuggestionBox actual = SuggestionBox.getByComponentInstanceId(this.suggestionBox.getComponentInstanceId());
        return actual.persistedSuggestions().isEmpty();
    }

    @Override
    public boolean contains(Object suggestion) {
        SuggestionBox actual = SuggestionBox.getByComponentInstanceId(this.suggestionBox.getComponentInstanceId());
        return actual.persistedSuggestions().contains(suggestion);
    }

    @Override
    public Iterator<Suggestion> iterator() {
        SuggestionBox actual = SuggestionBox.getByComponentInstanceId(this.suggestionBox.getComponentInstanceId());
        return actual.persistedSuggestions().iterator();
    }

    @Override
    public Object[] toArray() {
        SuggestionBox actual = SuggestionBox.getByComponentInstanceId(this.suggestionBox.getComponentInstanceId());
        return actual.persistedSuggestions().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        SuggestionBox actual = SuggestionBox.getByComponentInstanceId(this.suggestionBox.getComponentInstanceId());
        return actual.persistedSuggestions().toArray(a);
    }

    @Override
    public boolean add(Suggestion suggestion) {
        this.add(suggestion, null);
        return true;
    }

    public void add(Suggestion suggestion, Collection<UploadedFile> uploadedFiles) {
        Transaction.performInOne(() -> {
            SuggestionRepository suggestionRepository = this.getSuggestionRepository();
            SuggestionBox actual = SuggestionBox.getByComponentInstanceId(this.suggestionBox.getComponentInstanceId());
            suggestion.setSuggestionBox(actual);
            actual.persistedSuggestions().add(suggestion);
            suggestionRepository.save(suggestion);
            Attachments.from((Collection)uploadedFiles).attachTo((Contribution)suggestion);
            return null;
        });
    }

    @Override
    public boolean remove(Object aSuggestion) {
        Suggestion suggestion = (Suggestion)((Object)aSuggestion);
        return (Boolean)Transaction.performInOne(() -> {
            SuggestionRepository suggestionRepository = this.getSuggestionRepository();
            Suggestion actual = suggestionRepository.getById(suggestion.getId());
            suggestionRepository.delete(actual);
            return true;
        });
    }

    @Override
    public boolean containsAll(Collection<?> suggestions) {
        SuggestionBox actual = SuggestionBox.getByComponentInstanceId(this.suggestionBox.getComponentInstanceId());
        return actual.persistedSuggestions().containsAll(suggestions);
    }

    @Override
    public boolean addAll(Collection<? extends Suggestion> suggestions) {
        Transaction.performInOne(() -> {
            SuggestionRepository suggestionRepository = this.getSuggestionRepository();
            for (Suggestion suggestion : suggestions) {
                SuggestionBox actual = SuggestionBox.getByComponentInstanceId(this.suggestionBox.getComponentInstanceId());
                suggestion.setSuggestionBox(actual);
                actual.persistedSuggestions().add(suggestion);
                suggestionRepository.save(suggestion);
            }
            return null;
        });
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> theSuggestions) {
        return (Boolean)Transaction.performInOne(() -> {
            Collection suggestions = theSuggestions;
            SuggestionRepository suggestionRepository = this.getSuggestionRepository();
            Boolean changed = false;
            for (Suggestion suggestion : suggestions) {
                Suggestion actual = suggestionRepository.getById(suggestion.getId());
                if (!suggestion.getSuggestionBox().equals((Object)this.suggestionBox) || !actual.getValidation().isInDraft() && !actual.getValidation().isRefused()) continue;
                suggestionRepository.delete(actual);
                changed = true;
            }
            return changed;
        });
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        SuggestionBox actual = SuggestionBox.getByComponentInstanceId(this.suggestionBox.getComponentInstanceId());
        this.removeAll(actual.persistedSuggestions());
    }

    public Suggestion get(String suggestionId) {
        Suggestion suggestion = Suggestion.NONE;
        SuggestionCriteria criteria = SuggestionCriteria.from(this.suggestionBox).identifierIsOneOf(suggestionId);
        List<Suggestion> suggestions = this.getSuggestionRepository().findByCriteria(criteria.withWysiwygContent());
        if (suggestions.size() == 1) {
            suggestion = suggestions.get(0);
        }
        return suggestion;
    }

    public List<Suggestion> findInDraftFor(User user) {
        SuggestionCriteria criteria = SuggestionCriteria.from(this.suggestionBox).createdBy(user).statusIsOneOf(ContributionStatus.DRAFT).orderedBy(SuggestionCriteria.QUERY_ORDER_BY.LAST_UPDATE_DATE_ASC);
        return this.getSuggestionRepository().findByCriteria(criteria);
    }

    public List<Suggestion> findOutOfDraftFor(User user) {
        SuggestionCriteria criteria = SuggestionCriteria.from(this.suggestionBox).createdBy(user).statusIsOneOf(ContributionStatus.REFUSED, ContributionStatus.PENDING_VALIDATION, ContributionStatus.VALIDATED).orderedBy(SuggestionCriteria.QUERY_ORDER_BY.LAST_UPDATE_DATE_DESC);
        return this.getSuggestionRepository().findByCriteria(criteria);
    }

    public List<Suggestion> findPublishedFor(User user) {
        SuggestionCriteria criteria = SuggestionCriteria.from(this.suggestionBox).createdBy(user).statusIsOneOf(ContributionStatus.VALIDATED).orderedBy(SuggestionCriteria.QUERY_ORDER_BY.LAST_UPDATE_DATE_DESC);
        return this.getSuggestionRepository().findByCriteria(criteria);
    }

    public List<Suggestion> findPendingValidation() {
        return this.findInStatus(ContributionStatus.PENDING_VALIDATION);
    }

    public List<Suggestion> findPublished() {
        SuggestionCriteria criteria = SuggestionCriteria.from(this.suggestionBox).statusIsOneOf(ContributionStatus.VALIDATED).orderedBy(SuggestionCriteria.QUERY_ORDER_BY.VALIDATION_DATE_DESC);
        return this.getSuggestionRepository().findByCriteria(criteria);
    }

    public Suggestion publish(Suggestion suggestion) {
        SuggestionRepository suggestionRepository = this.getSuggestionRepository();
        Pair result = (Pair)Transaction.performInOne(() -> {
            User updater;
            SilverpeasRole highestUserRole;
            boolean triggerNotif = false;
            Suggestion actual = this.get(suggestion.getId());
            if ((actual.getValidation().isInDraft() || actual.getValidation().isRefused()) && (highestUserRole = this.suggestionBox.getHighestUserRole(updater = suggestion.getLastUpdater())).isGreaterThanOrEquals(SilverpeasRole.WRITER)) {
                ContributionValidation validation = actual.getValidation();
                if (highestUserRole.isGreaterThanOrEquals(SilverpeasRole.PUBLISHER)) {
                    validation.setStatus(ContributionStatus.VALIDATED);
                    validation.setDate(new Date());
                    validation.setValidator(updater);
                } else {
                    validation.setStatus(ContributionStatus.PENDING_VALIDATION);
                }
                suggestionRepository.save(actual);
                triggerNotif = true;
            }
            return Pair.of((Object)((Object)actual), (Object)triggerNotif);
        });
        Suggestion updatedSuggestion = (Suggestion)((Object)result.getLeft());
        if (((Boolean)result.getRight()).booleanValue()) {
            switch (updatedSuggestion.getValidation().getStatus()) {
                case PENDING_VALIDATION: {
                    UserNotificationHelper.buildAndSend((UserNotificationBuilder)new SuggestionPendingValidationUserNotification(updatedSuggestion));
                    break;
                }
                case VALIDATED: {
                    suggestionRepository.index(updatedSuggestion);
                    UserNotificationHelper.buildAndSend((UserNotificationBuilder)new SuggestionBoxSubscriptionUserNotification(updatedSuggestion));
                    break;
                }
            }
        }
        return updatedSuggestion;
    }

    public Suggestion validate(Suggestion suggestion, ContributionValidation validation) {
        SuggestionRepository suggestionRepository = this.getSuggestionRepository();
        Pair result = (Pair)Transaction.performInOne(() -> {
            boolean triggerNotif = false;
            Suggestion actual = this.get(suggestion.getId());
            if (actual.getValidation().isPendingValidation()) {
                User updater = suggestion.getLastUpdater();
                SilverpeasRole highestUserRole = this.suggestionBox.getHighestUserRole(updater);
                if (highestUserRole.isGreaterThanOrEquals(SilverpeasRole.PUBLISHER)) {
                    ContributionValidation actualValidation = actual.getValidation();
                    actualValidation.setStatus(validation.getStatus());
                    actualValidation.setComment(validation.getComment());
                    actualValidation.setDate(new Date());
                    actualValidation.setValidator(updater);
                }
                suggestionRepository.save(actual);
                triggerNotif = true;
            }
            return Pair.of((Object)((Object)actual), (Object)triggerNotif);
        });
        Suggestion updatedSuggestion = (Suggestion)((Object)result.getLeft());
        if (((Boolean)result.getRight()).booleanValue()) {
            switch (updatedSuggestion.getValidation().getStatus()) {
                case VALIDATED: {
                    suggestionRepository.index(updatedSuggestion);
                    UserNotificationHelper.buildAndSend((UserNotificationBuilder)new SuggestionBoxSubscriptionUserNotification(updatedSuggestion));
                    UserNotificationHelper.buildAndSend((UserNotificationBuilder)new SuggestionValidationUserNotification(updatedSuggestion));
                    break;
                }
                case REFUSED: {
                    UserNotificationHelper.buildAndSend((UserNotificationBuilder)new SuggestionValidationUserNotification(updatedSuggestion));
                    break;
                }
            }
        }
        return updatedSuggestion;
    }

    public List<Suggestion> findInStatus(ContributionStatus ... statuses) {
        SuggestionCriteria criteria = SuggestionCriteria.from(this.suggestionBox).statusIsOneOf(statuses).orderedBy(SuggestionCriteria.QUERY_ORDER_BY.STATUS_ASC, SuggestionCriteria.QUERY_ORDER_BY.LAST_UPDATE_DATE_ASC);
        return this.getSuggestionRepository().findByCriteria(criteria);
    }

    public List<Suggestion> findAllProposedBy(User author) {
        SuggestionCriteria criteria = SuggestionCriteria.from(this.suggestionBox).createdBy(author).orderedBy(SuggestionCriteria.QUERY_ORDER_BY.STATUS_ASC, SuggestionCriteria.QUERY_ORDER_BY.LAST_UPDATE_DATE_ASC);
        return this.getSuggestionRepository().findByCriteria(criteria);
    }

    public void index() {
        SuggestionRepository suggestionRepository = this.getSuggestionRepository();
        List<Suggestion> suggestions = suggestionRepository.findByCriteria(SuggestionCriteria.from(this.suggestionBox).statusIsOneOf(ContributionStatus.VALIDATED));
        for (Suggestion suggestion : suggestions) {
            suggestionRepository.index(suggestion);
        }
    }

    private SuggestionRepository getSuggestionRepository() {
        return SuggestionRepository.get();
    }
}

