/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Clock;
import com.google.api.core.ApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.FirebaseTokenUtils;
import com.google.firebase.auth.FirebaseTokenVerifier;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.ImportUserRecord;
import com.google.firebase.auth.ListUsersPage;
import com.google.firebase.auth.RevocationCheckDecorator;
import com.google.firebase.auth.SessionCookieOptions;
import com.google.firebase.auth.UserImportOptions;
import com.google.firebase.auth.UserImportResult;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.FirebaseTokenFactory;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FirebaseAuth {
    private static final String SERVICE_ID = FirebaseAuth.class.getName();
    private static final String ERROR_CUSTOM_TOKEN = "ERROR_CUSTOM_TOKEN";
    private final Object lock = new Object();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final FirebaseApp firebaseApp;
    private final Supplier<FirebaseTokenFactory> tokenFactory;
    private final Supplier<? extends FirebaseTokenVerifier> idTokenVerifier;
    private final Supplier<? extends FirebaseTokenVerifier> cookieVerifier;
    private final Supplier<? extends FirebaseUserManager> userManager;
    private final JsonFactory jsonFactory;

    private FirebaseAuth(Builder builder) {
        this.firebaseApp = (FirebaseApp)Preconditions.checkNotNull((Object)builder.firebaseApp);
        this.tokenFactory = this.threadSafeMemoize(builder.tokenFactory);
        this.idTokenVerifier = this.threadSafeMemoize(builder.idTokenVerifier);
        this.cookieVerifier = this.threadSafeMemoize(builder.cookieVerifier);
        this.userManager = this.threadSafeMemoize(builder.userManager);
        this.jsonFactory = this.firebaseApp.getOptions().getJsonFactory();
    }

    public static FirebaseAuth getInstance() {
        return FirebaseAuth.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseAuth getInstance(FirebaseApp app) {
        FirebaseAuthService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseAuthService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseAuthService(app));
        }
        return (FirebaseAuth)service.getInstance();
    }

    public String createSessionCookie(@NonNull String idToken, @NonNull SessionCookieOptions options) throws FirebaseAuthException {
        return this.createSessionCookieOp(idToken, options).call();
    }

    public ApiFuture<String> createSessionCookieAsync(@NonNull String idToken, @NonNull SessionCookieOptions options) {
        return this.createSessionCookieOp(idToken, options).callAsync(this.firebaseApp);
    }

    private CallableOperation<String, FirebaseAuthException> createSessionCookieOp(final String idToken, final SessionCookieOptions options) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)idToken) ? 1 : 0) != 0, (Object)"idToken must not be null or empty");
        Preconditions.checkNotNull((Object)options, (Object)"options must not be null");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<String, FirebaseAuthException>(){

            @Override
            protected String execute() throws FirebaseAuthException {
                return userManager.createSessionCookie(idToken, options);
            }
        };
    }

    public FirebaseToken verifySessionCookie(String cookie) throws FirebaseAuthException {
        return this.verifySessionCookie(cookie, false);
    }

    public FirebaseToken verifySessionCookie(String cookie, boolean checkRevoked) throws FirebaseAuthException {
        return this.verifySessionCookieOp(cookie, checkRevoked).call();
    }

    public ApiFuture<FirebaseToken> verifySessionCookieAsync(String cookie) {
        return this.verifySessionCookieAsync(cookie, false);
    }

    public ApiFuture<FirebaseToken> verifySessionCookieAsync(String cookie, boolean checkRevoked) {
        return this.verifySessionCookieOp(cookie, checkRevoked).callAsync(this.firebaseApp);
    }

    private CallableOperation<FirebaseToken, FirebaseAuthException> verifySessionCookieOp(final String cookie, boolean checkRevoked) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cookie) ? 1 : 0) != 0, (Object)"Session cookie must not be null or empty");
        final FirebaseTokenVerifier sessionCookieVerifier = this.getSessionCookieVerifier(checkRevoked);
        return new CallableOperation<FirebaseToken, FirebaseAuthException>(){

            @Override
            public FirebaseToken execute() throws FirebaseAuthException {
                return sessionCookieVerifier.verifyToken(cookie);
            }
        };
    }

    @VisibleForTesting
    FirebaseTokenVerifier getSessionCookieVerifier(boolean checkRevoked) {
        FirebaseTokenVerifier verifier = (FirebaseTokenVerifier)this.cookieVerifier.get();
        if (checkRevoked) {
            FirebaseUserManager userManager = this.getUserManager();
            verifier = RevocationCheckDecorator.decorateSessionCookieVerifier(verifier, userManager);
        }
        return verifier;
    }

    public String createCustomToken(@NonNull String uid) throws FirebaseAuthException {
        return this.createCustomToken(uid, null);
    }

    public String createCustomToken(@NonNull String uid, @Nullable Map<String, Object> developerClaims) throws FirebaseAuthException {
        return this.createCustomTokenOp(uid, developerClaims).call();
    }

    public ApiFuture<String> createCustomTokenAsync(@NonNull String uid) {
        return this.createCustomTokenAsync(uid, null);
    }

    public ApiFuture<String> createCustomTokenAsync(@NonNull String uid, @Nullable Map<String, Object> developerClaims) {
        return this.createCustomTokenOp(uid, developerClaims).callAsync(this.firebaseApp);
    }

    private CallableOperation<String, FirebaseAuthException> createCustomTokenOp(final String uid, final Map<String, Object> developerClaims) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        final FirebaseTokenFactory tokenFactory = (FirebaseTokenFactory)this.tokenFactory.get();
        return new CallableOperation<String, FirebaseAuthException>(){

            @Override
            public String execute() throws FirebaseAuthException {
                try {
                    return tokenFactory.createSignedCustomAuthTokenForUser(uid, developerClaims);
                }
                catch (IOException e) {
                    throw new FirebaseAuthException(FirebaseAuth.ERROR_CUSTOM_TOKEN, "Failed to generate a custom token", e);
                }
            }
        };
    }

    public FirebaseToken verifyIdToken(@NonNull String token) throws FirebaseAuthException {
        return this.verifyIdToken(token, false);
    }

    public FirebaseToken verifyIdToken(@NonNull String token, boolean checkRevoked) throws FirebaseAuthException {
        return this.verifyIdTokenOp(token, checkRevoked).call();
    }

    public ApiFuture<FirebaseToken> verifyIdTokenAsync(@NonNull String token) {
        return this.verifyIdTokenAsync(token, false);
    }

    public ApiFuture<FirebaseToken> verifyIdTokenAsync(@NonNull String token, boolean checkRevoked) {
        return this.verifyIdTokenOp(token, checkRevoked).callAsync(this.firebaseApp);
    }

    private CallableOperation<FirebaseToken, FirebaseAuthException> verifyIdTokenOp(final String token, boolean checkRevoked) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0, (Object)"ID token must not be null or empty");
        final FirebaseTokenVerifier verifier = this.getIdTokenVerifier(checkRevoked);
        return new CallableOperation<FirebaseToken, FirebaseAuthException>(){

            @Override
            protected FirebaseToken execute() throws FirebaseAuthException {
                return verifier.verifyToken(token);
            }
        };
    }

    @VisibleForTesting
    FirebaseTokenVerifier getIdTokenVerifier(boolean checkRevoked) {
        FirebaseTokenVerifier verifier = (FirebaseTokenVerifier)this.idTokenVerifier.get();
        if (checkRevoked) {
            FirebaseUserManager userManager = this.getUserManager();
            verifier = RevocationCheckDecorator.decorateIdTokenVerifier(verifier, userManager);
        }
        return verifier;
    }

    public void revokeRefreshTokens(@NonNull String uid) throws FirebaseAuthException {
        this.revokeRefreshTokensOp(uid).call();
    }

    public ApiFuture<Void> revokeRefreshTokensAsync(@NonNull String uid) {
        return this.revokeRefreshTokensOp(uid).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> revokeRefreshTokensOp(final String uid) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                int currentTimeSeconds = (int)(System.currentTimeMillis() / 1000L);
                UserRecord.UpdateRequest request = new UserRecord.UpdateRequest(uid).setValidSince(currentTimeSeconds);
                userManager.updateUser(request, FirebaseAuth.this.jsonFactory);
                return null;
            }
        };
    }

    public UserRecord getUser(@NonNull String uid) throws FirebaseAuthException {
        return this.getUserOp(uid).call();
    }

    public ApiFuture<UserRecord> getUserAsync(@NonNull String uid) {
        return this.getUserOp(uid).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> getUserOp(final String uid) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                return userManager.getUserById(uid);
            }
        };
    }

    public UserRecord getUserByEmail(@NonNull String email) throws FirebaseAuthException {
        return this.getUserByEmailOp(email).call();
    }

    public ApiFuture<UserRecord> getUserByEmailAsync(@NonNull String email) {
        return this.getUserByEmailOp(email).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> getUserByEmailOp(final String email) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0, (Object)"email must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                return userManager.getUserByEmail(email);
            }
        };
    }

    public UserRecord getUserByPhoneNumber(@NonNull String phoneNumber) throws FirebaseAuthException {
        return this.getUserByPhoneNumberOp(phoneNumber).call();
    }

    public ApiFuture<UserRecord> getUserByPhoneNumberAsync(@NonNull String phoneNumber) {
        return this.getUserByPhoneNumberOp(phoneNumber).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> getUserByPhoneNumberOp(final String phoneNumber) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)phoneNumber) ? 1 : 0) != 0, (Object)"phone number must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                return userManager.getUserByPhoneNumber(phoneNumber);
            }
        };
    }

    public ListUsersPage listUsers(@Nullable String pageToken) throws FirebaseAuthException {
        return this.listUsers(pageToken, 1000);
    }

    public ListUsersPage listUsers(@Nullable String pageToken, int maxResults) throws FirebaseAuthException {
        return this.listUsersOp(pageToken, maxResults).call();
    }

    public ApiFuture<ListUsersPage> listUsersAsync(@Nullable String pageToken) {
        return this.listUsersAsync(pageToken, 1000);
    }

    public ApiFuture<ListUsersPage> listUsersAsync(@Nullable String pageToken, int maxResults) {
        return this.listUsersOp(pageToken, maxResults).callAsync(this.firebaseApp);
    }

    private CallableOperation<ListUsersPage, FirebaseAuthException> listUsersOp(@Nullable String pageToken, int maxResults) {
        this.checkNotDestroyed();
        FirebaseUserManager userManager = this.getUserManager();
        final ListUsersPage.PageFactory factory = new ListUsersPage.PageFactory(new ListUsersPage.DefaultUserSource(userManager, this.jsonFactory), maxResults, pageToken);
        return new CallableOperation<ListUsersPage, FirebaseAuthException>(){

            @Override
            protected ListUsersPage execute() throws FirebaseAuthException {
                return factory.create();
            }
        };
    }

    public UserRecord createUser(@NonNull UserRecord.CreateRequest request) throws FirebaseAuthException {
        return this.createUserOp(request).call();
    }

    public ApiFuture<UserRecord> createUserAsync(@NonNull UserRecord.CreateRequest request) {
        return this.createUserOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> createUserOp(final UserRecord.CreateRequest request) {
        this.checkNotDestroyed();
        Preconditions.checkNotNull((Object)request, (Object)"create request must not be null");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                String uid = userManager.createUser(request);
                return userManager.getUserById(uid);
            }
        };
    }

    public UserRecord updateUser(@NonNull UserRecord.UpdateRequest request) throws FirebaseAuthException {
        return this.updateUserOp(request).call();
    }

    public ApiFuture<UserRecord> updateUserAsync(@NonNull UserRecord.UpdateRequest request) {
        return this.updateUserOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> updateUserOp(final UserRecord.UpdateRequest request) {
        this.checkNotDestroyed();
        Preconditions.checkNotNull((Object)request, (Object)"update request must not be null");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                userManager.updateUser(request, FirebaseAuth.this.jsonFactory);
                return userManager.getUserById(request.getUid());
            }
        };
    }

    public void setCustomUserClaims(@NonNull String uid, @Nullable Map<String, Object> claims) throws FirebaseAuthException {
        this.setCustomUserClaimsOp(uid, claims).call();
    }

    public void setCustomClaims(@NonNull String uid, @Nullable Map<String, Object> claims) throws FirebaseAuthException {
        this.setCustomUserClaims(uid, claims);
    }

    public ApiFuture<Void> setCustomUserClaimsAsync(@NonNull String uid, @Nullable Map<String, Object> claims) {
        return this.setCustomUserClaimsOp(uid, claims).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> setCustomUserClaimsOp(final String uid, final Map<String, Object> claims) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                UserRecord.UpdateRequest request = new UserRecord.UpdateRequest(uid).setCustomClaims(claims);
                userManager.updateUser(request, FirebaseAuth.this.jsonFactory);
                return null;
            }
        };
    }

    public void deleteUser(@NonNull String uid) throws FirebaseAuthException {
        this.deleteUserOp(uid).call();
    }

    public ApiFuture<Void> deleteUserAsync(String uid) {
        return this.deleteUserOp(uid).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> deleteUserOp(final String uid) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                userManager.deleteUser(uid);
                return null;
            }
        };
    }

    public UserImportResult importUsers(List<ImportUserRecord> users) throws FirebaseAuthException {
        return this.importUsers(users, null);
    }

    public UserImportResult importUsers(List<ImportUserRecord> users, @Nullable UserImportOptions options) throws FirebaseAuthException {
        return this.importUsersOp(users, options).call();
    }

    public ApiFuture<UserImportResult> importUsersAsync(List<ImportUserRecord> users) {
        return this.importUsersAsync(users, null);
    }

    public ApiFuture<UserImportResult> importUsersAsync(List<ImportUserRecord> users, @Nullable UserImportOptions options) {
        return this.importUsersOp(users, options).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserImportResult, FirebaseAuthException> importUsersOp(List<ImportUserRecord> users, UserImportOptions options) {
        this.checkNotDestroyed();
        final FirebaseUserManager.UserImportRequest request = new FirebaseUserManager.UserImportRequest(users, options, this.jsonFactory);
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<UserImportResult, FirebaseAuthException>(){

            @Override
            protected UserImportResult execute() throws FirebaseAuthException {
                return userManager.importUsers(request);
            }
        };
    }

    public String generatePasswordResetLink(@NonNull String email) throws FirebaseAuthException {
        return this.generatePasswordResetLink(email, null);
    }

    public String generatePasswordResetLink(@NonNull String email, @Nullable ActionCodeSettings settings) throws FirebaseAuthException {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.PASSWORD_RESET, email, settings).call();
    }

    public ApiFuture<String> generatePasswordResetLinkAsync(@NonNull String email) {
        return this.generatePasswordResetLinkAsync(email, null);
    }

    public ApiFuture<String> generatePasswordResetLinkAsync(@NonNull String email, @Nullable ActionCodeSettings settings) {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.PASSWORD_RESET, email, settings).callAsync(this.firebaseApp);
    }

    public String generateEmailVerificationLink(@NonNull String email) throws FirebaseAuthException {
        return this.generateEmailVerificationLink(email, null);
    }

    public String generateEmailVerificationLink(@NonNull String email, @Nullable ActionCodeSettings settings) throws FirebaseAuthException {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.VERIFY_EMAIL, email, settings).call();
    }

    public ApiFuture<String> generateEmailVerificationLinkAsync(@NonNull String email) {
        return this.generateEmailVerificationLinkAsync(email, null);
    }

    public ApiFuture<String> generateEmailVerificationLinkAsync(@NonNull String email, @Nullable ActionCodeSettings settings) {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.VERIFY_EMAIL, email, settings).callAsync(this.firebaseApp);
    }

    public String generateSignInWithEmailLink(@NonNull String email, @NonNull ActionCodeSettings settings) throws FirebaseAuthException {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.EMAIL_SIGNIN, email, settings).call();
    }

    public ApiFuture<String> generateSignInWithEmailLinkAsync(String email, @NonNull ActionCodeSettings settings) {
        return this.generateEmailActionLinkOp(FirebaseUserManager.EmailLinkType.EMAIL_SIGNIN, email, settings).callAsync(this.firebaseApp);
    }

    @VisibleForTesting
    FirebaseUserManager getUserManager() {
        return (FirebaseUserManager)this.userManager.get();
    }

    private CallableOperation<String, FirebaseAuthException> generateEmailActionLinkOp(final FirebaseUserManager.EmailLinkType type, final String email, final ActionCodeSettings settings) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0, (Object)"email must not be null or empty");
        if (type == FirebaseUserManager.EmailLinkType.EMAIL_SIGNIN) {
            Preconditions.checkNotNull((Object)settings, (Object)"ActionCodeSettings must not be null when generating sign-in links");
        }
        final FirebaseUserManager userManager = this.getUserManager();
        return new CallableOperation<String, FirebaseAuthException>(){

            @Override
            protected String execute() throws FirebaseAuthException {
                return userManager.getEmailActionLink(type, email, settings);
            }
        };
    }

    private <T> Supplier<T> threadSafeMemoize(final Supplier<T> supplier) {
        return Suppliers.memoize((Supplier)new Supplier<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T get() {
                Preconditions.checkNotNull((Object)supplier);
                Object object = FirebaseAuth.this.lock;
                synchronized (object) {
                    FirebaseAuth.this.checkNotDestroyed();
                    return supplier.get();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotDestroyed() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.destroyed.get() ? 1 : 0) != 0, (Object)"FirebaseAuth instance is no longer alive. This happens when the parent FirebaseApp instance has been deleted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.destroyed.set(true);
        }
    }

    private static FirebaseAuth fromApp(final FirebaseApp app) {
        return FirebaseAuth.builder().setFirebaseApp(app).setTokenFactory(new Supplier<FirebaseTokenFactory>(){

            public FirebaseTokenFactory get() {
                return FirebaseTokenUtils.createTokenFactory(app, Clock.SYSTEM);
            }
        }).setIdTokenVerifier((Supplier<? extends FirebaseTokenVerifier>)new Supplier<FirebaseTokenVerifier>(){

            public FirebaseTokenVerifier get() {
                return FirebaseTokenUtils.createIdTokenVerifier(app, Clock.SYSTEM);
            }
        }).setCookieVerifier((Supplier<? extends FirebaseTokenVerifier>)new Supplier<FirebaseTokenVerifier>(){

            public FirebaseTokenVerifier get() {
                return FirebaseTokenUtils.createSessionCookieVerifier(app, Clock.SYSTEM);
            }
        }).setUserManager(new Supplier<FirebaseUserManager>(){

            public FirebaseUserManager get() {
                return new FirebaseUserManager(app);
            }
        }).build();
    }

    @VisibleForTesting
    static Builder builder() {
        return new Builder();
    }

    private static class FirebaseAuthService
    extends FirebaseService<FirebaseAuth> {
        FirebaseAuthService(FirebaseApp app) {
            super(SERVICE_ID, FirebaseAuth.fromApp(app));
        }

        @Override
        public void destroy() {
            ((FirebaseAuth)this.instance).destroy();
        }
    }

    static class Builder {
        private FirebaseApp firebaseApp;
        private Supplier<FirebaseTokenFactory> tokenFactory;
        private Supplier<? extends FirebaseTokenVerifier> idTokenVerifier;
        private Supplier<? extends FirebaseTokenVerifier> cookieVerifier;
        private Supplier<FirebaseUserManager> userManager;

        private Builder() {
        }

        Builder setFirebaseApp(FirebaseApp firebaseApp) {
            this.firebaseApp = firebaseApp;
            return this;
        }

        Builder setTokenFactory(Supplier<FirebaseTokenFactory> tokenFactory) {
            this.tokenFactory = tokenFactory;
            return this;
        }

        Builder setIdTokenVerifier(Supplier<? extends FirebaseTokenVerifier> idTokenVerifier) {
            this.idTokenVerifier = idTokenVerifier;
            return this;
        }

        Builder setCookieVerifier(Supplier<? extends FirebaseTokenVerifier> cookieVerifier) {
            this.cookieVerifier = cookieVerifier;
            return this;
        }

        Builder setUserManager(Supplier<FirebaseUserManager> userManager) {
            this.userManager = userManager;
            return this;
        }

        FirebaseAuth build() {
            return new FirebaseAuth(this);
        }
    }
}

