/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.model;

import java.io.Serializable;
import java.util.UUID;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="sc_whitepages_searchfields")
@NamedQuery(name="whitepages.findByInstanceId", query="select sf from SearchField sf where sf.instanceId = :instanceId")
public class SearchField
implements Serializable {
    private static final long serialVersionUID = -2840717090501728479L;
    @Id
    private String id;
    private String instanceId;
    private String fieldId;
    @Transient
    private String label;

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fieldId == null ? 0 : this.fieldId.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchField other = (SearchField)obj;
        return this.instanceId.equals(other.getInstanceId()) && this.fieldId.equals(other.getFieldId());
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        if (StringUtil.isDefined((String)this.label)) {
            return this.label;
        }
        return this.getFieldName();
    }

    public String getFieldName() {
        return this.getFieldId().substring(4);
    }

    @PrePersist
    protected void generateId() {
        this.id = UUID.randomUUID().toString();
    }
}

