/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.delegatednews.notification;

import java.util.Collection;
import java.util.Collections;
import org.owasp.encoder.Encode;
import org.silverpeas.components.delegatednews.model.DelegatedNews;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.util.StringUtil;

abstract class AbstractDelegatedNewsUserNotification
extends AbstractTemplateUserNotificationBuilder<DelegatedNews> {
    private final User user;
    private final PublicationDetail publication;

    AbstractDelegatedNewsUserNotification(DelegatedNews delegatedNews, User user) {
        super((Object)delegatedNews);
        this.user = user;
        this.publication = delegatedNews.getPublicationDetail();
    }

    protected void performTemplateData(String language, DelegatedNews resource, SilverpeasTemplate template) {
        String title = StringUtil.defaultStringIfNotDefined((String)this.getTitle(language), (String)this.getTitle());
        this.getNotificationMetaData().addLanguage(language, title, "");
        template.setAttribute("publicationId", (Object)this.publication.getId());
        template.setAttribute("publicationName", (Object)Encode.forHtml((String)this.publication.getName(language)));
        template.setAttribute("senderName", (Object)(this.user != null ? this.user.getDisplayedName() : ""));
    }

    protected void performNotificationResource(String language, DelegatedNews resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setFeminineGender(true);
        notificationResourceData.setResourceName(this.publication.getName(language));
    }

    protected void perform(DelegatedNews resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    protected String getTemplatePath() {
        return "delegatednews";
    }

    protected String getComponentInstanceId() {
        return this.getPublication().getInstanceId();
    }

    protected String getSender() {
        return this.user.getId();
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.delegatednews.multilang.DelegatedNewsBundle";
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "delegatednews.notifLinkLabel";
    }

    protected String getResourceURL(DelegatedNews delegatedNews) {
        return URLUtil.getSimpleURL((int)2, (String)this.publication.getId(), (boolean)false);
    }

    protected boolean stopWhenNoUserToNotify() {
        return false;
    }

    protected Collection<String> getUserIdsToNotify() {
        return Collections.singletonList(this.getPublication().getUpdaterId());
    }

    protected PublicationDetail getPublication() {
        return this.publication;
    }

    protected boolean isSendImmediately() {
        return true;
    }
}

