/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.FirebaseTokenVerifier;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.UserRecord;

class RevocationCheckDecorator
implements FirebaseTokenVerifier {
    static final String ID_TOKEN_REVOKED_ERROR = "id-token-revoked";
    static final String SESSION_COOKIE_REVOKED_ERROR = "session-cookie-revoked";
    private final FirebaseTokenVerifier tokenVerifier;
    private final FirebaseUserManager userManager;
    private final String errorCode;
    private final String shortName;

    private RevocationCheckDecorator(FirebaseTokenVerifier tokenVerifier, FirebaseUserManager userManager, String errorCode, String shortName) {
        this.tokenVerifier = (FirebaseTokenVerifier)Preconditions.checkNotNull((Object)tokenVerifier);
        this.userManager = (FirebaseUserManager)Preconditions.checkNotNull((Object)userManager);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)errorCode) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)shortName) ? 1 : 0) != 0);
        this.errorCode = errorCode;
        this.shortName = shortName;
    }

    @Override
    public FirebaseToken verifyToken(String token) throws FirebaseAuthException {
        FirebaseToken firebaseToken = this.tokenVerifier.verifyToken(token);
        if (this.isRevoked(firebaseToken)) {
            throw new FirebaseAuthException(this.errorCode, "Firebase " + this.shortName + " revoked");
        }
        return firebaseToken;
    }

    private boolean isRevoked(FirebaseToken firebaseToken) throws FirebaseAuthException {
        UserRecord user = this.userManager.getUserById(firebaseToken.getUid());
        long issuedAtInSeconds = (Long)firebaseToken.getClaims().get("iat");
        return user.getTokensValidAfterTimestamp() > issuedAtInSeconds * 1000L;
    }

    static RevocationCheckDecorator decorateIdTokenVerifier(FirebaseTokenVerifier tokenVerifier, FirebaseUserManager userManager) {
        return new RevocationCheckDecorator(tokenVerifier, userManager, ID_TOKEN_REVOKED_ERROR, "id token");
    }

    static RevocationCheckDecorator decorateSessionCookieVerifier(FirebaseTokenVerifier tokenVerifier, FirebaseUserManager userManager) {
        return new RevocationCheckDecorator(tokenVerifier, userManager, SESSION_COOKIE_REVOKED_ERROR, "session cookie");
    }
}

