/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.server;

import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.Util;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.apt.RfValidator;
import com.google.web.bindery.requestfactory.apt.ValidationTool;
import com.google.web.bindery.requestfactory.gwt.client.RequestBatcher;
import com.google.web.bindery.requestfactory.server.DefaultExceptionHandler;
import com.google.web.bindery.requestfactory.server.ExceptionHandler;
import com.google.web.bindery.requestfactory.server.Logging;
import com.google.web.bindery.requestfactory.server.RequestFactoryServlet;
import com.google.web.bindery.requestfactory.server.ServiceLayer;
import com.google.web.bindery.requestfactory.server.ServiceLayerDecorator;
import com.google.web.bindery.requestfactory.server.SimpleRequestProcessor;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.DefaultProxyStore;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyChange;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.ExtraTypes;
import com.google.web.bindery.requestfactory.shared.InstanceRequest;
import com.google.web.bindery.requestfactory.shared.JsonRpcContent;
import com.google.web.bindery.requestfactory.shared.JsonRpcProxy;
import com.google.web.bindery.requestfactory.shared.JsonRpcService;
import com.google.web.bindery.requestfactory.shared.JsonRpcWireName;
import com.google.web.bindery.requestfactory.shared.Locator;
import com.google.web.bindery.requestfactory.shared.LoggingRequest;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.ProxyForName;
import com.google.web.bindery.requestfactory.shared.ProxySerializer;
import com.google.web.bindery.requestfactory.shared.ProxyStore;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.RequestTransport;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.ServiceLocator;
import com.google.web.bindery.requestfactory.shared.ServiceName;
import com.google.web.bindery.requestfactory.shared.ValueProxy;
import com.google.web.bindery.requestfactory.shared.Violation;
import com.google.web.bindery.requestfactory.shared.WriteOperation;
import com.google.web.bindery.requestfactory.vm.RequestFactorySource;
import com.google.web.bindery.requestfactory.vm.testing.UrlRequestTransport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.annotation.processing.Processor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class RequestFactoryJarExtractor {
    private static final boolean VERBOSE = false;
    private static final String CODE_AND_SOURCE = "+src";
    private static final String SOURCE_ONLY = "-src";
    private static final String NATIVE_METHOD_ERROR = "Cannot call native method";
    private static final Map<String, List<Class<?>>> SEEDS = new LinkedHashMap();
    private static final Class<?>[] SERVER_CLASSES = new Class[]{DefaultExceptionHandler.class, ExceptionHandler.class, Logging.class, LoggingRequest.class, RequestFactoryServlet.class, ServiceLayer.class, ServiceLayerDecorator.class, SimpleRequestProcessor.class};
    private static final Class<?>[] SHARED_CLASSES = new Class[]{BaseProxy.class, DefaultProxyStore.class, EntityProxy.class, EntityProxyChange.class, EntityProxyId.class, ExtraTypes.class, InstanceRequest.class, JsonRpcContent.class, JsonRpcProxy.class, JsonRpcService.class, JsonRpcWireName.class, Locator.class, ProxyFor.class, ProxyForName.class, ProxySerializer.class, ProxyStore.class, Receiver.class, Request.class, RequestBatcher.class, RequestContext.class, RequestFactory.class, RequestTransport.class, ServerFailure.class, Service.class, ServiceLocator.class, ServiceName.class, ValueProxy.class, Violation.class, WriteOperation.class, RequestFactorySource.class, SimpleEventBus.class};
    private static final int MAX_THREADS = 4;
    private boolean executionFailed = false;
    private final Emitter emitter;
    private final ExecutorService ex;
    private final BlockingQueue<Future<?>> inProcess = new LinkedBlockingQueue();
    private final ErrorContext logger;
    private final Loader loader;
    private final Mode mode;
    private final Map<String, byte[]> resources;
    private final List<Class<?>> seeds;
    private final Map<Type, Type> seen = new ConcurrentHashMap<Type, Type>();
    private final Set<String> sources = new ConcurrentSkipListSet<String>();
    private final ExecutorService writerService;

    public static void main(String[] args) throws IOException {
        String target;
        List<Class<?>> seeds;
        if (args.length < 2) {
            System.err.println("Usage: java -cp gwt-dev.jar:gwt-user.jar:json.jar" + RequestFactoryJarExtractor.class.getCanonicalName() + " <target-name> outfile.jar");
            System.err.println("Valid targets:");
            for (String target2 : SEEDS.keySet()) {
                System.err.println("  " + target2);
            }
            System.exit(1);
        }
        if ((seeds = SEEDS.get(target = args[0])) == null) {
            System.err.println("Unknown target: " + target);
            System.exit(1);
        }
        Map<String, byte[]> resources = RequestFactoryJarExtractor.createResources(seeds);
        Mode mode = Mode.match(target);
        Logger errorContext = Logger.getLogger(RequestFactoryJarExtractor.class.getName());
        ClassLoaderLoader classLoader = new ClassLoaderLoader(Thread.currentThread().getContextClassLoader());
        JarEmitter jarEmitter = new JarEmitter(new File(args[1]));
        RequestFactoryJarExtractor extractor = new RequestFactoryJarExtractor(errorContext, classLoader, jarEmitter, seeds, resources, mode);
        extractor.run();
        System.exit(extractor.isExecutionFailed() ? 1 : 0);
    }

    private static Map<String, byte[]> createResources(List<Class<?>> seeds) throws UnsupportedEncodingException, IOException {
        Map<String, byte[]> resources = seeds.contains(RfValidator.class) ? Collections.singletonMap("META-INF/services/" + Processor.class.getCanonicalName(), RfValidator.class.getCanonicalName().getBytes("UTF-8")) : Collections.emptyMap();
        return resources;
    }

    private static String getPackagePath(Type t) {
        String name = t.getInternalName();
        return name.substring(0, name.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean visit(ErrorContext logger, Loader loader, String internalName, ClassVisitor visitor) {
        block17: {
            boolean bl;
            assert (Name.isInternalName(internalName)) : "internalName";
            logger.spam("Visiting " + internalName, new Object[0]);
            InputStream inputStream = null;
            try {
                inputStream = loader.getResourceAsStream(internalName + ".class");
                if (inputStream == null) {
                    System.err.println("Could not find class file for " + internalName);
                    logger.poison("Could not find class file for " + internalName, new Object[0]);
                    boolean bl2 = false;
                    return bl2;
                }
                ClassReader reader = new ClassReader(inputStream);
                reader.accept(visitor, 0);
                bl = true;
            }
            catch (IOException e) {
                logger.poison("Unable to open " + internalName, e);
                break block17;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    public RequestFactoryJarExtractor(Logger logger, Loader loader, Emitter emitter, List<Class<?>> seeds, Map<String, byte[]> resources, Mode mode) {
        this.logger = new ErrorContext(logger);
        this.loader = loader;
        this.emitter = emitter;
        this.resources = resources;
        this.seeds = seeds;
        this.mode = mode;
        int numThreads = Math.min(4, Runtime.getRuntime().availableProcessors());
        this.ex = Executors.newFixedThreadPool(numThreads);
        this.writerService = Executors.newSingleThreadExecutor();
    }

    public void run() throws IOException {
        for (Class<?> clazz : this.seeds) {
            this.processType("seeds", Type.getType(clazz));
        }
        for (Map.Entry entry : this.resources.entrySet()) {
            this.writerService.submit(new EmitOneResource((String)entry.getKey(), (byte[])entry.getValue()));
        }
        while (!this.inProcess.isEmpty()) {
            try {
                Future<?> task = this.inProcess.take();
                task.get();
            }
            catch (InterruptedException task) {
            }
            catch (ExecutionException e) {
                e.getCause().printStackTrace();
                this.executionFailed = true;
            }
        }
        this.emitter.close();
    }

    private void emit(State state) {
        this.inProcess.add(this.writerService.submit(new EmitOneType(state)));
    }

    private boolean isExecutionFailed() {
        return this.executionFailed;
    }

    private Object processConstant(String sourceType, Object value) {
        if (value instanceof Type) {
            value = this.processType(sourceType, (Type)value);
        }
        return value;
    }

    private String processDescriptor(String sourceType, String desc) {
        if (desc == null) {
            return null;
        }
        return this.processType(sourceType, Type.getType((String)desc)).getDescriptor();
    }

    private String processInternalName(String sourceType, String internalName) {
        if (internalName == null) {
            return null;
        }
        return this.processType(sourceType, Type.getObjectType((String)internalName)).getInternalName();
    }

    private Method processMethod(String sourceType, String name, String desc) {
        Method method = new Method(name, desc);
        Type[] argumentTypes = method.getArgumentTypes();
        int j = argumentTypes.length;
        for (int i = 0; i < j; ++i) {
            argumentTypes[i] = this.processType(sourceType, argumentTypes[i]);
        }
        method = new Method(name, this.processType(sourceType, method.getReturnType()), argumentTypes);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type processType(String sourceType, Type type) {
        Type toReturn;
        Map<Type, Type> map = this.seen;
        synchronized (map) {
            toReturn = this.seen.get(type);
            if (toReturn != null) {
                return toReturn;
            }
            toReturn = Type.getType((String)type.getDescriptor());
            this.seen.put(type, toReturn);
        }
        int sort = type.getSort();
        if (sort != 10 && sort != 9) {
            return toReturn;
        }
        if (sort == 9) {
            this.processType(sourceType, type.getElementType());
            return toReturn;
        }
        assert (type.getInternalName().charAt(0) != 'L');
        if (type.getInternalName().startsWith("java/") || type.getInternalName().startsWith("javax/") || type.getInternalName().startsWith("jakarta/") || type.getInternalName().startsWith("com/google/gson/")) {
            return toReturn;
        }
        Future<State> future = this.ex.submit(new ProcessOneType(type));
        this.inProcess.add(future);
        return toReturn;
    }

    static {
        List<Class> aptClasses = Collections.unmodifiableList(Arrays.asList(RfValidator.class, ValidationTool.class));
        List<Class<?>> sharedClasses = Arrays.asList(SHARED_CLASSES);
        ArrayList clientClasses = new ArrayList();
        clientClasses.addAll(sharedClasses);
        clientClasses.add(UrlRequestTransport.class);
        ArrayList serverClasses = new ArrayList();
        serverClasses.addAll(Arrays.asList(SERVER_CLASSES));
        serverClasses.addAll(sharedClasses);
        SEEDS.put("apt", aptClasses);
        SEEDS.put("client", Collections.unmodifiableList(clientClasses));
        SEEDS.put("server", Collections.unmodifiableList(serverClasses));
        SEEDS.put("server-jakarta", Collections.unmodifiableList(serverClasses));
        LinkedHashSet all = new LinkedHashSet();
        for (List<Class<?>> value : SEEDS.values()) {
            all.addAll(value);
        }
        SEEDS.put("all", Collections.unmodifiableList(new ArrayList(all)));
        for (String target : new ArrayList<String>(SEEDS.keySet())) {
            SEEDS.put(target + SOURCE_ONLY, SEEDS.get(target));
            SEEDS.put(target + CODE_AND_SOURCE, SEEDS.get(target));
        }
        try {
            List<Class> testClasses = Collections.unmodifiableList(Arrays.asList(Class.forName("com.google.web.bindery.requestfactory.vm.RequestFactoryJreSuite"), Class.forName("com.google.web.bindery.requestfactory.server.SimpleBar")));
            SEEDS.put("test", testClasses);
            SEEDS.put("test-src", testClasses);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class State {
        boolean containsNativeMethods;
        InputStream contents;
        String source;
        Type type;
        final Type originalType;

        public State(Type type) {
            this.originalType = this.type = type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.type.getInternalName());
            if (this.containsNativeMethods) {
                sb.append(" NATIVE");
            }
            if (this.source != null) {
                sb.append(" ").append(this.source);
            }
            return sb.toString();
        }
    }

    static class ErrorContext {
        private final Logger logger;
        private final ErrorContext parent;
        private Type currentType;
        private Method currentMethod;

        private static String print(Method method) {
            StringBuilder sb = new StringBuilder();
            sb.append(ErrorContext.print(method.getReturnType())).append(" ").append(method.getName()).append("(");
            for (Type t : method.getArgumentTypes()) {
                sb.append(ErrorContext.print(t)).append(" ");
            }
            sb.append(")");
            return sb.toString();
        }

        private static String print(Type type) {
            return Name.SourceOrBinaryName.toSourceName(type.getClassName());
        }

        public ErrorContext(Logger logger) {
            this.logger = logger;
            this.parent = null;
        }

        protected ErrorContext(ErrorContext parent) {
            this.logger = parent.logger;
            this.parent = parent;
        }

        public void poison(String msg, Object ... args) {
            this.poison();
            this.logger.logp(Level.SEVERE, this.currentType(), this.currentMethod(), String.format(msg, args));
        }

        public void poison(String msg, Throwable t) {
            this.poison();
            this.logger.logp(Level.SEVERE, this.currentType(), this.currentMethod(), msg, t);
        }

        public ErrorContext setMethod(Method method) {
            ErrorContext toReturn = this.fork();
            toReturn.currentMethod = method;
            return toReturn;
        }

        public ErrorContext setType(Type type) {
            ErrorContext toReturn = this.fork();
            toReturn.currentType = type;
            return toReturn;
        }

        public void spam(String msg, Object ... args) {
            this.logger.logp(Level.FINEST, this.currentType(), this.currentMethod(), String.format(msg, args));
        }

        protected ErrorContext fork() {
            return new ErrorContext(this);
        }

        private String currentMethod() {
            if (this.currentMethod != null) {
                return ErrorContext.print(this.currentMethod);
            }
            if (this.parent != null) {
                return this.parent.currentMethod();
            }
            return null;
        }

        private String currentType() {
            if (this.currentType != null) {
                return ErrorContext.print(this.currentType);
            }
            if (this.parent != null) {
                return this.parent.currentType();
            }
            return null;
        }

        private void poison() {
            if (this.parent != null) {
                this.parent.poison();
            }
        }
    }

    public static interface Loader {
        public boolean exists(String var1);

        public InputStream getResourceAsStream(String var1);
    }

    public static interface Emitter {
        public void close() throws IOException;

        public void emit(String var1, InputStream var2) throws IOException;
    }

    public static enum Mode {
        BOTH(true, true){

            @Override
            protected boolean matches(String target) {
                return target.endsWith(RequestFactoryJarExtractor.CODE_AND_SOURCE);
            }
        }
        ,
        SOURCE(false, true){

            @Override
            protected boolean matches(String target) {
                return target.endsWith(RequestFactoryJarExtractor.SOURCE_ONLY);
            }
        }
        ,
        CLASSES(true, false){

            @Override
            protected boolean matches(String target) {
                return true;
            }
        };

        private final boolean emitClasses;
        private final boolean emitSource;

        public static Mode match(String target) {
            for (Mode mode : Mode.values()) {
                if (!mode.matches(target)) continue;
                return mode;
            }
            return null;
        }

        private Mode(boolean emitClasses, boolean emitSource) {
            this.emitClasses = emitClasses;
            this.emitSource = emitSource;
        }

        public boolean isEmitClasses() {
            return this.emitClasses;
        }

        public boolean isEmitSource() {
            return this.emitSource;
        }

        protected abstract boolean matches(String var1);
    }

    public static class ClassLoaderLoader
    implements Loader {
        private final ClassLoader loader;

        public ClassLoaderLoader(ClassLoader loader) {
            this.loader = loader;
        }

        @Override
        public boolean exists(String resource) {
            return this.loader.getResource(resource) != null;
        }

        @Override
        public InputStream getResourceAsStream(String resource) {
            return this.loader.getResourceAsStream(resource);
        }
    }

    public static class JarEmitter
    implements Emitter {
        private int rawByteSize;
        private final JarOutputStream out;

        public JarEmitter(File outFile) throws IOException {
            Manifest m = new Manifest();
            m.getMainAttributes().putValue("Created-By", RequestFactoryJarExtractor.class.getCanonicalName());
            m.getMainAttributes();
            this.out = new JarOutputStream((OutputStream)new FileOutputStream(outFile), m);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void emit(String path, InputStream contents) throws IOException {
            int read;
            ZipEntry entry = new ZipEntry(path);
            this.out.putNextEntry(entry);
            byte[] bytes = new byte[4096];
            while ((read = contents.read(bytes)) != -1) {
                this.rawByteSize += read;
                this.out.write(bytes, 0, read);
            }
            this.out.closeEntry();
        }
    }

    private class EmitOneResource
    implements Callable<Void> {
        private final byte[] contents;
        private final String path;

        private EmitOneResource(String path, byte[] contents) {
            this.path = path;
            this.contents = contents;
        }

        @Override
        public Void call() throws Exception {
            if (RequestFactoryJarExtractor.this.mode.isEmitClasses()) {
                RequestFactoryJarExtractor.this.emitter.emit(this.path, new ByteArrayInputStream(this.contents));
            }
            return null;
        }
    }

    private class EmitOneType
    implements Callable<Void> {
        private final State state;

        private EmitOneType(State state) {
            this.state = state;
        }

        @Override
        public Void call() throws Exception {
            if (RequestFactoryJarExtractor.this.mode.isEmitClasses()) {
                String fileName = this.state.type.getInternalName();
                if (fileName == null) {
                    System.err.println("Got null filename from " + this.state.type);
                    return null;
                }
                fileName = fileName + ".class";
                RequestFactoryJarExtractor.this.emitter.emit(fileName, this.state.contents);
            }
            if (RequestFactoryJarExtractor.this.mode.isEmitSource()) {
                String sourcePath = RequestFactoryJarExtractor.getPackagePath(this.state.originalType) + this.state.source;
                String destPath = RequestFactoryJarExtractor.getPackagePath(this.state.type) + this.state.source;
                if (RequestFactoryJarExtractor.this.sources.add(sourcePath) && RequestFactoryJarExtractor.this.loader.exists(sourcePath)) {
                    String contents = Util.readStreamAsString((InputStream)RequestFactoryJarExtractor.this.loader.getResourceAsStream(sourcePath));
                    RequestFactoryJarExtractor.this.emitter.emit(destPath, new ByteArrayInputStream(Util.getBytes((String)contents)));
                }
            }
            return null;
        }
    }

    private class ProcessOneType
    implements Callable<State> {
        private final State state;
        private final String typeName;

        public ProcessOneType(Type type) {
            this.state = new State(type);
            this.typeName = type.getClassName();
        }

        @Override
        public State call() {
            ClassWriter writer;
            Object cv = writer = new ClassWriter(0);
            cv = new ClassProcessor(this.typeName, (ClassVisitor)cv, this.state);
            cv = new NativeMethodDefanger((ClassVisitor)cv);
            RequestFactoryJarExtractor.visit(RequestFactoryJarExtractor.this.logger.setType(this.state.type), RequestFactoryJarExtractor.this.loader, this.state.type.getInternalName(), (ClassVisitor)cv);
            this.state.contents = new ByteArrayInputStream(writer.toByteArray());
            assert (RequestFactoryJarExtractor.this.seen.containsKey(this.state.originalType)) : "No type for " + this.state.type.getClassName();
            this.state.type = (Type)RequestFactoryJarExtractor.this.seen.get(this.state.originalType);
            RequestFactoryJarExtractor.this.emit(this.state);
            return this.state;
        }
    }

    private class NativeMethodDefanger
    extends ClassVisitor {
        public NativeMethodDefanger(ClassVisitor cv) {
            super(589824, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 0x100) != 0) {
                MethodVisitor mv = super.visitMethod(access & 0xFFFFFEFF, name, desc, signature, exceptions);
                if (mv != null) {
                    mv.visitCode();
                    String exceptionName = Type.getInternalName(RuntimeException.class);
                    mv.visitTypeInsn(187, exceptionName);
                    mv.visitInsn(89);
                    mv.visitLdcInsn((Object)RequestFactoryJarExtractor.NATIVE_METHOD_ERROR);
                    mv.visitMethodInsn(183, exceptionName, "<init>", "(Ljava/lang/String;)V", false);
                    mv.visitInsn(191);
                    int numSlots = 0;
                    for (Type t : Type.getArgumentTypes((String)desc)) {
                        numSlots += t.getSize();
                    }
                    if ((access & 8) == 0) {
                        ++numSlots;
                    }
                    mv.visitMaxs(3, numSlots);
                    mv.visitEnd();
                }
                return null;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }

    private class MethodProcessor
    extends MethodVisitor {
        private final String sourceType;

        public MethodProcessor(String sourceType, MethodVisitor mv) {
            super(589824, mv);
            this.sourceType = sourceType;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            return super.visitAnnotation(desc, visible);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationProcessor(this.sourceType, super.visitAnnotationDefault());
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            owner = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, owner);
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            int i;
            int j = local.length;
            for (i = 0; i < j; ++i) {
                if (!(local[i] instanceof String)) continue;
                local[i] = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, (String)local[i]);
            }
            j = stack.length;
            for (i = 0; i < j; ++i) {
                if (!(stack[i] instanceof String)) continue;
                stack[i] = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, (String)stack[i]);
            }
            super.visitFrame(type, nLocal, local, nStack, stack);
        }

        public void visitLdcInsn(Object cst) {
            cst = RequestFactoryJarExtractor.this.processConstant(this.sourceType, cst);
            super.visitLdcInsn(cst);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean dintf) {
            owner = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, owner);
            desc = RequestFactoryJarExtractor.this.processMethod(this.sourceType, name, desc).getDescriptor();
            super.visitMethodInsn(opcode, owner, name, desc, dintf);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            return super.visitParameterAnnotation(parameter, desc, visible);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            type = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, type);
            super.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitTypeInsn(int opcode, String type) {
            type = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, type);
            super.visitTypeInsn(opcode, type);
        }
    }

    private class FieldProcessor
    extends FieldVisitor {
        private final String sourceType;
        private final FieldVisitor fv;

        public FieldProcessor(String sourceType, FieldVisitor fv) {
            super(589824);
            this.sourceType = sourceType;
            this.fv = fv;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationProcessor(this.sourceType, this.fv.visitAnnotation(desc, visible));
        }

        public void visitAttribute(Attribute attr) {
            this.fv.visitAttribute(attr);
        }

        public void visitEnd() {
            this.fv.visitEnd();
        }
    }

    private class ClassProcessor
    extends ClassVisitor {
        private State state;
        private String sourceType;

        public ClassProcessor(String sourceType, ClassVisitor cv, State state) {
            super(589824, cv);
            this.sourceType = sourceType;
            this.state = state;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            name = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, name);
            superName = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, superName);
            if (interfaces != null) {
                int j = interfaces.length;
                for (int i = 0; i < j; ++i) {
                    interfaces[i] = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, interfaces[i]);
                }
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            return new AnnotationProcessor(this.sourceType, super.visitAnnotation(desc, visible));
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            return new FieldProcessor(this.sourceType, super.visitField(access, name, desc, signature, value));
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            name = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, name);
            outerName = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, outerName);
            super.visitInnerClass(name, outerName, innerName, access);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv;
            Method method = RequestFactoryJarExtractor.this.processMethod(this.sourceType, name, desc);
            desc = method.getDescriptor();
            if (exceptions != null) {
                int j = exceptions.length;
                for (int i = 0; i < j; ++i) {
                    exceptions[i] = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, exceptions[i]);
                }
            }
            if ((mv = super.visitMethod(access, name, desc, signature, exceptions)) != null) {
                mv = new MethodProcessor(this.sourceType, mv);
            }
            return mv;
        }

        public void visitOuterClass(String owner, String name, String desc) {
            owner = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, owner);
            if (desc != null) {
                desc = RequestFactoryJarExtractor.this.processMethod(this.sourceType, name, desc).getDescriptor();
            }
            super.visitOuterClass(owner, name, desc);
        }

        public void visitSource(String source, String debug) {
            if (source != null) {
                this.state.source = source;
            }
            super.visitSource(source, debug);
        }
    }

    private class AnnotationProcessor
    extends AnnotationVisitor {
        private final String sourceType;
        private final AnnotationVisitor av;

        public AnnotationProcessor(String sourceType, AnnotationVisitor av) {
            super(589824);
            this.sourceType = sourceType;
            this.av = av;
        }

        public void visit(String name, Object value) {
            value = RequestFactoryJarExtractor.this.processConstant(this.sourceType, value);
            this.av.visit(name, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            return new AnnotationProcessor(desc, this.av.visitAnnotation(name, desc));
        }

        public AnnotationVisitor visitArray(String name) {
            return new AnnotationProcessor(name, this.av.visitArray(name));
        }

        public void visitEnd() {
            this.av.visitEnd();
        }

        public void visitEnum(String name, String desc, String value) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            this.av.visitEnum(name, desc, value);
        }
    }
}

