/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.attributeparsers.DoubleAttributeParser;
import com.google.gwt.uibinder.attributeparsers.EnumAttributeParser;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LengthAttributeParser
implements AttributeParser {
    static final String UNIT = Style.Unit.class.getCanonicalName();
    private static final Pattern pattern = Pattern.compile("((?:\\{[\\w\\.]+\\})|[\\+\\-]?[\\d\\.]+)\\s*(\\{?[\\w\\.\\%]*\\}?)?");
    private final MortalLogger logger;
    private final DoubleAttributeParser doubleParser;
    private final EnumAttributeParser enumParser;

    LengthAttributeParser(DoubleAttributeParser doubleParser, EnumAttributeParser enumParser, MortalLogger logger) {
        this.doubleParser = doubleParser;
        this.enumParser = enumParser;
        this.logger = logger;
    }

    @Override
    public String parse(XMLElement source, String lengthStr) throws UnableToCompleteException {
        Matcher matcher = pattern.matcher(lengthStr);
        if (!matcher.matches()) {
            this.logger.die(source, "Unable to parse %s as length", new Object[]{lengthStr});
        }
        String valueStr = matcher.group(1);
        String value = this.doubleParser.parse(source, valueStr);
        String unit = null;
        String unitStr = matcher.group(2);
        if (unitStr.length() > 0) {
            if (!unitStr.startsWith("{")) {
                if ("%".equals(unitStr)) {
                    unitStr = "PCT";
                }
                unitStr = unitStr.toUpperCase(Locale.ROOT);
            }
            unit = this.enumParser.parse(source, unitStr);
        } else {
            unit = UNIT + ".PX";
        }
        return value + ", " + unit;
    }
}

