/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

public final class MethodSpec {
    static final String CONSTRUCTOR = "<init>";
    public final String name;
    public final CodeBlock javadoc;
    public final List<AnnotationSpec> annotations;
    public final Set<Modifier> modifiers;
    public final List<TypeVariableName> typeVariables;
    public final TypeName returnType;
    public final List<ParameterSpec> parameters;
    public final boolean varargs;
    public final List<TypeName> exceptions;
    public final CodeBlock code;

    private MethodSpec(Builder builder) {
        CodeBlock code = builder.code.build();
        Util.checkArgument(code.isEmpty() || !builder.modifiers.contains((Object)Modifier.ABSTRACT), "abstract method %s cannot have code", builder.name);
        Util.checkArgument(!builder.varargs || this.lastParameterIsArray(builder.parameters), "last parameter of varargs method %s must be an array", builder.name);
        this.name = Util.checkNotNull(builder.name, "name == null", new Object[0]);
        this.javadoc = builder.javadoc.build();
        this.annotations = Util.immutableList(builder.annotations);
        this.modifiers = Util.immutableSet(builder.modifiers);
        this.typeVariables = Util.immutableList(builder.typeVariables);
        this.returnType = builder.returnType;
        this.parameters = Util.immutableList(builder.parameters);
        this.varargs = builder.varargs;
        this.exceptions = Util.immutableList(builder.exceptions);
        this.code = code;
    }

    private boolean lastParameterIsArray(List<ParameterSpec> parameters) {
        return !parameters.isEmpty() && TypeName.arrayComponent(parameters.get((int)(parameters.size() - 1)).type) != null;
    }

    void emit(CodeWriter codeWriter, String enclosingName, Set<Modifier> implicitModifiers) throws IOException {
        codeWriter.emitJavadoc(this.javadoc);
        codeWriter.emitAnnotations(this.annotations, false);
        codeWriter.emitModifiers(this.modifiers, implicitModifiers);
        if (!this.typeVariables.isEmpty()) {
            codeWriter.emitTypeVariables(this.typeVariables);
            codeWriter.emit(" ", new Object[0]);
        }
        if (this.isConstructor()) {
            codeWriter.emit("$L(", enclosingName);
        } else {
            codeWriter.emit("$T $L(", this.returnType, this.name);
        }
        boolean firstParameter = true;
        Iterator<ParameterSpec> i = this.parameters.iterator();
        while (i.hasNext()) {
            ParameterSpec parameter = i.next();
            if (!firstParameter) {
                codeWriter.emit(", ", new Object[0]);
            }
            parameter.emit(codeWriter, !i.hasNext() && this.varargs);
            firstParameter = false;
        }
        codeWriter.emit(")", new Object[0]);
        if (!this.exceptions.isEmpty()) {
            codeWriter.emit(" throws", new Object[0]);
            boolean firstException = true;
            for (TypeName exception : this.exceptions) {
                if (!firstException) {
                    codeWriter.emit(",", new Object[0]);
                }
                codeWriter.emit(" $T", exception);
                firstException = false;
            }
        }
        if (this.hasModifier(Modifier.ABSTRACT)) {
            codeWriter.emit(";\n", new Object[0]);
        } else if (this.hasModifier(Modifier.NATIVE)) {
            codeWriter.emit(this.code);
            codeWriter.emit(";\n", new Object[0]);
        } else {
            codeWriter.emit(" {\n", new Object[0]);
            codeWriter.indent();
            codeWriter.emit(this.code);
            codeWriter.unindent();
            codeWriter.emit("}\n", new Object[0]);
        }
    }

    public boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public boolean isConstructor() {
        return this.name.equals(CONSTRUCTOR);
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            CodeWriter codeWriter = new CodeWriter(out);
            this.emit(codeWriter, "Constructor", Collections.emptySet());
            return out.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static Builder methodBuilder(String name) {
        return new Builder(name);
    }

    public static Builder constructorBuilder() {
        return new Builder(CONSTRUCTOR);
    }

    public static final class Builder {
        private final String name;
        private final CodeBlock.Builder javadoc = CodeBlock.builder();
        private final List<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
        private final List<Modifier> modifiers = new ArrayList<Modifier>();
        private List<TypeVariableName> typeVariables = new ArrayList<TypeVariableName>();
        private TypeName returnType;
        private final List<ParameterSpec> parameters = new ArrayList<ParameterSpec>();
        private final List<TypeName> exceptions = new ArrayList<TypeName>();
        private final CodeBlock.Builder code = CodeBlock.builder();
        private boolean varargs;

        private Builder(String name) {
            Util.checkArgument(name.equals(MethodSpec.CONSTRUCTOR) || SourceVersion.isName(name), "not a valid name: %s", name);
            this.name = name;
            this.returnType = name.equals(MethodSpec.CONSTRUCTOR) ? null : TypeName.VOID;
        }

        public Builder addJavadoc(String format, Object ... args) {
            this.javadoc.add(format, args);
            return this;
        }

        public Builder addAnnotation(AnnotationSpec annotationSpec) {
            this.annotations.add(annotationSpec);
            return this;
        }

        public Builder addAnnotation(ClassName annotation) {
            this.annotations.add(AnnotationSpec.builder(annotation).build());
            return this;
        }

        public Builder addAnnotation(Class<?> annotation) {
            return this.addAnnotation(ClassName.get(annotation));
        }

        public Builder addModifiers(Modifier ... modifiers) {
            Collections.addAll(this.modifiers, modifiers);
            return this;
        }

        public Builder addTypeVariable(TypeVariableName typeVariable) {
            this.typeVariables.add(typeVariable);
            return this;
        }

        public Builder returns(TypeName returnType) {
            Util.checkState(!this.name.equals(MethodSpec.CONSTRUCTOR), "constructor cannot have return type.", new Object[0]);
            this.returnType = returnType;
            return this;
        }

        public Builder returns(Type returnType) {
            return this.returns(TypeName.get(returnType));
        }

        public Builder addParameter(ParameterSpec parameterSpec) {
            this.parameters.add(parameterSpec);
            return this;
        }

        public Builder addParameter(TypeName type, String name, Modifier ... modifiers) {
            return this.addParameter(ParameterSpec.builder(type, name, modifiers).build());
        }

        public Builder addParameter(Type type, String name, Modifier ... modifiers) {
            return this.addParameter(TypeName.get(type), name, modifiers);
        }

        public Builder varargs() {
            this.varargs = true;
            return this;
        }

        public Builder addException(TypeName exception) {
            this.exceptions.add(exception);
            return this;
        }

        public Builder addException(Type exception) {
            return this.addException(TypeName.get(exception));
        }

        public Builder addCode(String format, Object ... args) {
            this.code.add(format, args);
            return this;
        }

        public Builder addCode(CodeBlock codeBlock) {
            this.code.add(codeBlock);
            return this;
        }

        public Builder beginControlFlow(String controlFlow, Object ... args) {
            this.code.beginControlFlow(controlFlow, args);
            return this;
        }

        public Builder nextControlFlow(String controlFlow, Object ... args) {
            this.code.nextControlFlow(controlFlow, args);
            return this;
        }

        public Builder endControlFlow() {
            this.code.endControlFlow();
            return this;
        }

        public Builder endControlFlow(String controlFlow, Object ... args) {
            this.code.endControlFlow(controlFlow, args);
            return this;
        }

        public Builder addStatement(String format, Object ... args) {
            this.code.addStatement(format, args);
            return this;
        }

        public MethodSpec build() {
            return new MethodSpec(this);
        }
    }
}

