/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;

public class Notification {
    @Key(value="title")
    private final String title;
    @Key(value="body")
    private final String body;
    @Key(value="image")
    private final String image;

    public Notification(String title, String body) {
        this(title, body, null);
    }

    public Notification(String title, String body, String imageUrl) {
        this.title = title;
        this.body = body;
        this.image = imageUrl;
    }

    private Notification(Builder builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.image = builder.image;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String body;
        private String image;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setImage(String imageUrl) {
            this.image = imageUrl;
            return this;
        }

        public Notification build() {
            return new Notification(this);
        }
    }
}

