/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.codegen.server;

import com.google.gwt.codegen.server.SourceWriter;

public abstract class SourceWriterBase
implements SourceWriter {
    private boolean atStart;
    private boolean inComment;
    private int indent;

    @Override
    public abstract void abort();

    @Override
    public void beginJavaDocComment() {
        this.println("\n/**");
        this.inComment = true;
    }

    @Override
    public void close() {
        this.outdent();
        this.println("}");
    }

    @Override
    public void endJavaDocComment() {
        this.inComment = false;
        this.println("\n */");
    }

    @Override
    public void indent() {
        ++this.indent;
    }

    @Override
    public void indentln(String string) {
        this.indent();
        this.println(string);
        this.outdent();
    }

    @Override
    public void indentln(String format, Object ... args) {
        this.indentln(String.format(format, args));
    }

    @Override
    public void outdent() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    @Override
    public void print(String s) {
        if (this.atStart) {
            for (int j = 0; j < this.indent; ++j) {
                this.writeString("  ");
            }
            if (this.inComment) {
                this.writeString(" * ");
            }
            this.atStart = false;
        }
        String rest = null;
        int i = s.indexOf("\n");
        if (i > -1 && i < s.length() - 1) {
            rest = s.substring(i + 1);
            s = s.substring(0, i + 1);
        }
        this.writeString(s);
        if (rest != null) {
            this.atStart = true;
            this.print(rest);
        }
    }

    @Override
    public void print(String format, Object ... args) {
        this.print(String.format(format, args));
    }

    @Override
    public void println() {
        this.print("\n");
        this.atStart = true;
    }

    @Override
    public void println(String string) {
        this.print(string);
        this.println();
    }

    @Override
    public void println(String format, Object ... args) {
        this.println(String.format(format, args));
    }

    protected abstract void writeString(String var1);
}

