/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.utilities.encoding;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.Exclude;
import com.google.firebase.database.GenericTypeIndicator;
import com.google.firebase.database.IgnoreExtraProperties;
import com.google.firebase.database.PropertyName;
import com.google.firebase.database.ThrowOnExtraProperties;
import com.google.firebase.database.utilities.Utilities;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomClassMapper {
    private static final Logger logger = LoggerFactory.getLogger(CustomClassMapper.class);
    private static final ConcurrentMap<Class<?>, BeanMapper<?>> mappers = new ConcurrentHashMap();

    public static Object convertToPlainJavaTypes(Object object) {
        return CustomClassMapper.serialize(object);
    }

    public static Map<String, Object> convertToPlainJavaTypes(Map<String, Object> update) {
        Object converted = CustomClassMapper.serialize(update);
        Utilities.hardAssert(converted instanceof Map);
        return (Map)converted;
    }

    public static <T> T convertToCustomClass(Object object, Class<T> clazz) {
        return CustomClassMapper.deserializeToClass(object, clazz);
    }

    public static <T> T convertToCustomClass(Object object, GenericTypeIndicator<T> typeIndicator) {
        Class<?> clazz = typeIndicator.getClass();
        Type genericTypeIndicatorType = clazz.getGenericSuperclass();
        if (genericTypeIndicatorType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericTypeIndicatorType;
            if (!parameterizedType.getRawType().equals(GenericTypeIndicator.class)) {
                throw new DatabaseException("Not a direct subclass of GenericTypeIndicator: " + genericTypeIndicatorType);
            }
            Type type = parameterizedType.getActualTypeArguments()[0];
            return CustomClassMapper.deserializeToType(object, type);
        }
        throw new DatabaseException("Not a direct subclass of GenericTypeIndicator: " + genericTypeIndicatorType);
    }

    private static <T> Object serialize(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            if (obj instanceof Float || obj instanceof Double) {
                double doubleValue = ((Number)obj).doubleValue();
                if (doubleValue <= 9.223372036854776E18 && doubleValue >= -9.223372036854776E18 && Math.floor(doubleValue) == doubleValue) {
                    return ((Number)obj).longValue();
                }
                return doubleValue;
            }
            if (obj instanceof Long || obj instanceof Integer) {
                return obj;
            }
            throw new DatabaseException(String.format("Numbers of type %s are not supported, please use an int, long, float or double", obj.getClass().getSimpleName()));
        }
        if (obj instanceof String) {
            return obj;
        }
        if (obj instanceof Boolean) {
            return obj;
        }
        if (obj instanceof Character) {
            throw new DatabaseException("Characters are not supported, please use Strings");
        }
        if (obj instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    String keyString = (String)key;
                    result.put(keyString, CustomClassMapper.serialize(entry.getValue()));
                    continue;
                }
                throw new DatabaseException("Maps with non-string keys are not supported");
            }
            return result;
        }
        if (obj instanceof Collection) {
            if (obj instanceof List) {
                List list = (List)obj;
                ArrayList<Object> result = new ArrayList<Object>(list.size());
                for (Object object : list) {
                    result.add(CustomClassMapper.serialize(object));
                }
                return result;
            }
            throw new DatabaseException("Serializing Collections is not supported, please use Lists instead");
        }
        if (obj.getClass().isArray()) {
            throw new DatabaseException("Serializing Arrays is not supported, please use Lists instead");
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        Class<?> clazz = obj.getClass();
        BeanMapper<?> mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(clazz);
        return mapper.serialize(obj);
    }

    private static <T> T deserializeToType(Object obj, Type type) {
        if (obj == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            return CustomClassMapper.deserializeToParameterizedType(obj, (ParameterizedType)type);
        }
        if (type instanceof Class) {
            return CustomClassMapper.deserializeToClass(obj, (Class)type);
        }
        if (type instanceof WildcardType) {
            throw new DatabaseException("Generic wildcard types are not supported");
        }
        if (type instanceof GenericArrayType) {
            throw new DatabaseException("Generic Arrays are not supported, please use Lists instead");
        }
        throw new IllegalStateException("Unknown type encountered: " + type);
    }

    private static <T> T deserializeToClass(Object obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            return CustomClassMapper.deserializeToPrimitive(obj, clazz);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertString(obj);
        }
        if (clazz.isArray()) {
            throw new DatabaseException("Converting to Arrays is not supported, please use Lists instead");
        }
        if (clazz.getTypeParameters().length > 0) {
            throw new DatabaseException("Class " + clazz.getName() + " has generic type parameters, please use GenericTypeIndicator instead");
        }
        if (clazz.equals(Object.class)) {
            return (T)obj;
        }
        if (clazz.isEnum()) {
            return CustomClassMapper.deserializeToEnum(obj, clazz);
        }
        return CustomClassMapper.convertBean(obj, clazz);
    }

    private static <T> T deserializeToParameterizedType(Object obj, ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        if (List.class.isAssignableFrom(rawType)) {
            Type genericType = type.getActualTypeArguments()[0];
            if (obj instanceof List) {
                List list = (List)obj;
                ArrayList<T> result = new ArrayList<T>(list.size());
                for (Object object : list) {
                    result.add(CustomClassMapper.deserializeToType(object, genericType));
                }
                return (T)result;
            }
            throw new DatabaseException("Expected a List while deserializing, but got a " + obj.getClass());
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (!keyType.equals(String.class)) {
                throw new DatabaseException("Only Maps with string keys are supported, but found Map with key type " + keyType);
            }
            Map<String, Object> map = CustomClassMapper.expectMap(obj);
            HashMap<String, T> result = new HashMap<String, T>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                result.put(entry.getKey(), CustomClassMapper.deserializeToType(entry.getValue(), valueType));
            }
            return (T)result;
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            throw new DatabaseException("Collections are not supported, please use Lists instead");
        }
        Map<String, Object> map = CustomClassMapper.expectMap(obj);
        BeanMapper mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(rawType);
        HashMap typeMapping = new HashMap();
        TypeVariable<Class<T>>[] typeVariables = mapper.clazz.getTypeParameters();
        Type[] types = type.getActualTypeArguments();
        if (types.length != typeVariables.length) {
            throw new IllegalStateException("Mismatched lengths for type variables and actual types");
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            typeMapping.put(typeVariables[i], types[i]);
        }
        return mapper.deserialize(map, typeMapping);
    }

    private static <T> T deserializeToPrimitive(Object obj, Class<T> clazz) {
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertInteger(obj);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertBoolean(obj);
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDouble(obj);
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertLong(obj);
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return (T)Float.valueOf(CustomClassMapper.convertDouble(obj).floatValue());
        }
        throw new DatabaseException(String.format("Deserializing values to %s is not supported", clazz.getSimpleName()));
    }

    private static <T> T deserializeToEnum(Object object, Class<T> clazz) {
        if (object instanceof String) {
            String value = (String)object;
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                throw new DatabaseException("Could not find enum value of " + clazz.getName() + " for value \"" + value + "\"");
            }
        }
        throw new DatabaseException("Expected a String while deserializing to enum " + clazz + " but got a " + object.getClass());
    }

    private static <T> BeanMapper<T> loadOrCreateBeanMapperForClass(Class<T> clazz) {
        BeanMapper<T> mapper = (BeanMapper<T>)mappers.get(clazz);
        if (mapper == null) {
            mapper = new BeanMapper<T>(clazz);
            mappers.put(clazz, mapper);
        }
        return mapper;
    }

    private static Map<String, Object> expectMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        throw new DatabaseException("Expected a Map while deserializing, but got a " + object.getClass());
    }

    private static Integer convertInteger(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long || obj instanceof Double) {
            double value = ((Number)obj).doubleValue();
            if (value >= -2.147483648E9 && value <= 2.147483647E9) {
                return ((Number)obj).intValue();
            }
            throw new DatabaseException("Numeric value out of 32-bit integer range: " + value + ". Did you mean to use a long or double instead of an int?");
        }
        throw new DatabaseException("Failed to convert a value of type " + obj.getClass().getName() + " to int");
    }

    private static Long convertLong(Object obj) {
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Double) {
            Double value = (Double)obj;
            if (value >= -9.223372036854776E18 && value <= 9.223372036854776E18) {
                return value.longValue();
            }
            throw new DatabaseException("Numeric value out of 64-bit long range: " + value + ". Did you mean to use a double instead of a long?");
        }
        throw new DatabaseException("Failed to convert a value of type " + obj.getClass().getName() + " to long");
    }

    private static Double convertDouble(Object obj) {
        if (obj instanceof Integer) {
            return ((Integer)obj).doubleValue();
        }
        if (obj instanceof Long) {
            Long value = (Long)obj;
            Double doubleValue = ((Long)obj).doubleValue();
            if (doubleValue.longValue() == value.longValue()) {
                return doubleValue;
            }
            throw new DatabaseException("Loss of precision while converting number to double: " + obj + ". Did you mean to use a 64-bit long instead?");
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        throw new DatabaseException("Failed to convert a value of type " + obj.getClass().getName() + " to double");
    }

    private static Boolean convertBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new DatabaseException("Failed to convert value of type " + obj.getClass().getName() + " to boolean");
    }

    private static String convertString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new DatabaseException("Failed to convert value of type " + obj.getClass().getName() + " to String");
    }

    private static <T> T convertBean(Object obj, Class<T> clazz) {
        BeanMapper<T> mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(clazz);
        if (obj instanceof Map) {
            return mapper.deserialize(CustomClassMapper.expectMap(obj));
        }
        throw new DatabaseException("Can't convert object of type " + obj.getClass().getName() + " to type " + clazz.getName());
    }

    private static class BeanMapper<T> {
        private final Class<T> clazz;
        private final Constructor<T> constructor;
        private final boolean throwOnUnknownProperties;
        private final boolean warnOnUnknownProperties;
        private final Map<String, String> properties;
        private final Map<String, Method> getters;
        private final Map<String, Method> setters;
        private final Map<String, Field> fields;

        /*
         * WARNING - void declaration
         */
        public BeanMapper(Class<T> clazz) {
            this.clazz = clazz;
            this.throwOnUnknownProperties = clazz.isAnnotationPresent(ThrowOnExtraProperties.class);
            this.warnOnUnknownProperties = !clazz.isAnnotationPresent(IgnoreExtraProperties.class);
            this.properties = new HashMap<String, String>();
            this.setters = new HashMap<String, Method>();
            this.getters = new HashMap<String, Method>();
            this.fields = new HashMap<String, Field>();
            Constructor<T> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                constructor = null;
            }
            this.constructor = constructor;
            for (Method method : clazz.getMethods()) {
                if (!BeanMapper.shouldIncludeGetter(method)) continue;
                String string = BeanMapper.propertyName(method);
                this.addProperty(string);
                method.setAccessible(true);
                if (this.getters.containsKey(string)) {
                    throw new DatabaseException("Found conflicting getters for name: " + method.getName());
                }
                this.getters.put(string, method);
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                if (!BeanMapper.shouldIncludeField((Field)accessibleObject)) continue;
                String string = BeanMapper.propertyName((Field)accessibleObject);
                this.addProperty(string);
            }
            Class<T> currentClass = clazz;
            do {
                void var6_13;
                int n;
                AccessibleObject[] accessibleObjectArray = currentClass.getDeclaredMethods();
                int n2 = accessibleObjectArray.length;
                boolean bl = false;
                while (n < n2) {
                    String propertyName2;
                    String existingPropertyName;
                    Method method = accessibleObjectArray[n];
                    if (BeanMapper.shouldIncludeSetter(method) && (existingPropertyName = this.properties.get((propertyName2 = BeanMapper.propertyName(method)).toLowerCase())) != null) {
                        if (!existingPropertyName.equals(propertyName2)) {
                            throw new DatabaseException("Found setter with invalid case-sensitive name: " + method.getName());
                        }
                        Method existingSetter = this.setters.get(propertyName2);
                        if (existingSetter == null) {
                            method.setAccessible(true);
                            this.setters.put(propertyName2, method);
                        } else if (!BeanMapper.isSetterOverride(method, existingSetter)) {
                            throw new DatabaseException("Found a conflicting setters with name: " + method.getName() + " (conflicts with " + existingSetter.getName() + " defined on " + existingSetter.getDeclaringClass().getName() + ")");
                        }
                    }
                    n += 1;
                }
                accessibleObjectArray = currentClass.getDeclaredFields();
                n2 = accessibleObjectArray.length;
                n = 0;
                while (var6_13 < n2) {
                    AccessibleObject accessibleObject = accessibleObjectArray[var6_13];
                    String propertyName = BeanMapper.propertyName((Field)accessibleObject);
                    if (this.properties.containsKey(propertyName.toLowerCase()) && !this.fields.containsKey(propertyName)) {
                        ((Field)accessibleObject).setAccessible(true);
                        this.fields.put(propertyName, (Field)accessibleObject);
                    }
                    ++var6_13;
                }
            } while ((currentClass = currentClass.getSuperclass()) != null && !currentClass.equals(Object.class));
            if (this.properties.isEmpty()) {
                throw new DatabaseException("No properties to serialize found on class " + clazz.getName());
            }
        }

        private static boolean shouldIncludeGetter(Method method) {
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
                return false;
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            if (method.getParameterTypes().length != 0) {
                return false;
            }
            return !method.isAnnotationPresent(Exclude.class);
        }

        private static boolean shouldIncludeSetter(Method method) {
            if (!method.getName().startsWith("set")) {
                return false;
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            if (method.getParameterTypes().length != 1) {
                return false;
            }
            return !method.isAnnotationPresent(Exclude.class);
        }

        private static boolean shouldIncludeField(Field field) {
            if (field.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (!Modifier.isPublic(field.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            if (Modifier.isTransient(field.getModifiers())) {
                return false;
            }
            return !field.isAnnotationPresent(Exclude.class);
        }

        private static boolean isSetterOverride(Method base, Method override) {
            Utilities.hardAssert(base.getDeclaringClass().isAssignableFrom(override.getDeclaringClass()), "Expected override from a base class");
            Utilities.hardAssert(base.getReturnType().equals(Void.TYPE), "Expected void return type");
            Utilities.hardAssert(override.getReturnType().equals(Void.TYPE), "Expected void return type");
            Class<?>[] baseParameterTypes = base.getParameterTypes();
            Class<?>[] overrideParameterTypes = override.getParameterTypes();
            Utilities.hardAssert(baseParameterTypes.length == 1, "Expected exactly one parameter");
            Utilities.hardAssert(overrideParameterTypes.length == 1, "Expected exactly one parameter");
            return base.getName().equals(override.getName()) && baseParameterTypes[0].equals(overrideParameterTypes[0]);
        }

        private static String propertyName(Field field) {
            String annotatedName = BeanMapper.annotatedName(field);
            return annotatedName != null ? annotatedName : field.getName();
        }

        private static String propertyName(Method method) {
            String annotatedName = BeanMapper.annotatedName(method);
            return annotatedName != null ? annotatedName : BeanMapper.serializedName(method.getName());
        }

        private static String annotatedName(AccessibleObject obj) {
            if (obj.isAnnotationPresent(PropertyName.class)) {
                PropertyName annotation = obj.getAnnotation(PropertyName.class);
                return annotation.value();
            }
            return null;
        }

        private static String serializedName(String methodName) {
            String[] prefixes = new String[]{"get", "set", "is"};
            String methodPrefix = null;
            for (String prefix : prefixes) {
                if (!methodName.startsWith(prefix)) continue;
                methodPrefix = prefix;
            }
            if (methodPrefix == null) {
                throw new IllegalArgumentException("Unknown Bean prefix for method: " + methodName);
            }
            String strippedName = methodName.substring(methodPrefix.length());
            char[] chars = strippedName.toCharArray();
            for (int pos = 0; pos < chars.length && Character.isUpperCase(chars[pos]); ++pos) {
                chars[pos] = Character.toLowerCase(chars[pos]);
            }
            return new String(chars);
        }

        private void addProperty(String property) {
            String oldValue = this.properties.put(property.toLowerCase(), property);
            if (oldValue != null && !property.equals(oldValue)) {
                throw new DatabaseException("Found two getters or fields with conflicting case sensitivity for property: " + property.toLowerCase());
            }
        }

        public T deserialize(Map<String, Object> values) {
            return this.deserialize(values, Collections.emptyMap());
        }

        public T deserialize(Map<String, Object> values, Map<TypeVariable<Class<T>>, Type> types) {
            T instance;
            if (this.constructor == null) {
                throw new DatabaseException("Class " + this.clazz.getName() + " is missing a constructor with no arguments");
            }
            try {
                instance = this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                String propertyName = entry.getKey();
                if (this.setters.containsKey(propertyName)) {
                    Method setter = this.setters.get(propertyName);
                    Type[] params = setter.getGenericParameterTypes();
                    if (params.length != 1) {
                        throw new IllegalStateException("Setter does not have exactly one parameter");
                    }
                    Type resolvedType = this.resolveType(params[0], types);
                    Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType);
                    try {
                        setter.invoke(instance, value);
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.fields.containsKey(propertyName)) {
                    Field field = this.fields.get(propertyName);
                    Type resolvedType = this.resolveType(field.getGenericType(), types);
                    Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType);
                    try {
                        field.set(instance, value);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                String message = "No setter/field for " + propertyName + " found on class " + this.clazz.getName();
                if (this.properties.containsKey(propertyName.toLowerCase())) {
                    message = message + " (fields/setters are case sensitive!)";
                }
                if (this.throwOnUnknownProperties) {
                    throw new DatabaseException(message);
                }
                if (!this.warnOnUnknownProperties) continue;
                logger.warn(message);
            }
            return instance;
        }

        private Type resolveType(Type type, Map<TypeVariable<Class<T>>, Type> types) {
            if (type instanceof TypeVariable) {
                Type resolvedType = types.get(type);
                if (resolvedType == null) {
                    throw new IllegalStateException("Could not resolve type " + type);
                }
                return resolvedType;
            }
            return type;
        }

        public Map<String, Object> serialize(T object) {
            if (!this.clazz.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException("Can't serialize object of class " + object.getClass() + " with BeanMapper for class " + this.clazz);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String property : this.properties.values()) {
                Object propertyValue;
                if (this.getters.containsKey(property)) {
                    Method getter = this.getters.get(property);
                    try {
                        propertyValue = getter.invoke(object, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                Field field = this.fields.get(property);
                if (field == null) {
                    throw new IllegalStateException("Bean property without field or getter:" + property);
                }
                try {
                    propertyValue = field.get(object);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                Object serializedValue = CustomClassMapper.serialize(propertyValue);
                result.put(property, serializedValue);
            }
            return result;
        }
    }
}

