/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.json.JsonFactory;
import com.google.common.io.BaseEncoding;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.DownloadAccountResponse;
import com.google.firebase.internal.Nullable;

public class ExportedUserRecord
extends UserRecord {
    private final String passwordHash;
    private final String passwordSalt;
    private static final String REDACTED_BASE64 = BaseEncoding.base64Url().encode("REDACTED".getBytes());

    ExportedUserRecord(DownloadAccountResponse.User response, JsonFactory jsonFactory) {
        super(response, jsonFactory);
        String passwordHash = response.getPasswordHash();
        this.passwordHash = passwordHash != null && !passwordHash.equals(REDACTED_BASE64) ? passwordHash : null;
        this.passwordSalt = response.getPasswordSalt();
    }

    @Nullable
    public String getPasswordHash() {
        return this.passwordHash;
    }

    @Nullable
    public String getPasswordSalt() {
        return this.passwordSalt;
    }
}

