/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.event.shared;

import java.util.Collections;
import java.util.Set;

public class UmbrellaException
extends RuntimeException {
    static final String MULTIPLE = " exceptions caught: ";
    static final String ONE = "Exception caught: ";
    private Set<Throwable> causes;

    protected static Throwable makeCause(Set<Throwable> causes) {
        return causes.isEmpty() ? null : causes.iterator().next();
    }

    protected static String makeMessage(Set<Throwable> causes) {
        int count = causes.size();
        if (count == 0) {
            return null;
        }
        StringBuilder b = new StringBuilder(count == 1 ? ONE : count + MULTIPLE);
        boolean first = true;
        for (Throwable t : causes) {
            if (first) {
                first = false;
            } else {
                b.append("; ");
            }
            b.append(t.getMessage());
        }
        return b.toString();
    }

    public UmbrellaException(Set<Throwable> causes) {
        super(UmbrellaException.makeMessage(causes), UmbrellaException.makeCause(causes));
        this.causes = causes;
        int i = 0;
        for (Throwable cause : causes) {
            if (i++ == 0) continue;
            this.addSuppressed(cause);
        }
    }

    protected UmbrellaException() {
        super(MULTIPLE);
        this.causes = Collections.emptySet();
    }

    public Set<Throwable> getCauses() {
        return this.causes;
    }
}

