/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class WildcardTypeName
extends TypeName {
    public final List<TypeName> upperBounds;
    public final List<TypeName> lowerBounds;

    private WildcardTypeName(List<TypeName> upperBounds, List<TypeName> lowerBounds) {
        this.upperBounds = Util.immutableList(upperBounds);
        this.lowerBounds = Util.immutableList(lowerBounds);
        Util.checkArgument(this.upperBounds.size() == 1, "unexpected extends bounds: %s", upperBounds);
        for (TypeName upperBound : this.upperBounds) {
            Util.checkArgument(!upperBound.isPrimitive() && upperBound != VOID, "invalid upper bound: %s", upperBound);
        }
        for (TypeName lowerBound : this.lowerBounds) {
            Util.checkArgument(!lowerBound.isPrimitive() && lowerBound != VOID, "invalid lower bound: %s", lowerBound);
        }
    }

    public boolean equals(Object o) {
        return o instanceof WildcardTypeName && ((WildcardTypeName)o).upperBounds.equals(this.upperBounds) && ((WildcardTypeName)o).lowerBounds.equals(this.lowerBounds);
    }

    public int hashCode() {
        return this.upperBounds.hashCode() ^ this.lowerBounds.hashCode();
    }

    @Override
    CodeWriter emit(CodeWriter out) throws IOException {
        if (this.lowerBounds.size() == 1) {
            return out.emit("? super $T", this.lowerBounds.get(0));
        }
        return this.upperBounds.get(0).equals(TypeName.OBJECT) ? out.emit("?", new Object[0]) : out.emit("? extends $T", this.upperBounds.get(0));
    }

    public static WildcardTypeName subtypeOf(TypeName upperBound) {
        return new WildcardTypeName(Arrays.asList(upperBound), Collections.emptyList());
    }

    public static WildcardTypeName subtypeOf(Type upperBound) {
        return WildcardTypeName.subtypeOf(TypeName.get(upperBound));
    }

    public static WildcardTypeName supertypeOf(TypeName lowerBound) {
        return new WildcardTypeName(Arrays.asList(OBJECT), Arrays.asList(lowerBound));
    }

    public static WildcardTypeName supertypeOf(Type lowerBound) {
        return WildcardTypeName.supertypeOf(TypeName.get(lowerBound));
    }

    public static TypeName get(javax.lang.model.type.WildcardType mirror) {
        TypeName extendsBound = TypeName.get(mirror.getExtendsBound());
        TypeName superBound = TypeName.get(mirror.getSuperBound());
        return superBound != null ? WildcardTypeName.supertypeOf(superBound) : WildcardTypeName.subtypeOf(extendsBound);
    }

    public static TypeName get(WildcardType wildcardName) {
        return new WildcardTypeName(WildcardTypeName.list(wildcardName.getUpperBounds()), WildcardTypeName.list(wildcardName.getLowerBounds()));
    }
}

