/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class TypeVariableName
extends TypeName {
    public final String name;
    public final List<TypeName> bounds;

    private TypeVariableName(String name, List<TypeName> bounds) {
        ArrayList<TypeName> boundsNoObject = new ArrayList<TypeName>(bounds);
        boundsNoObject.remove(OBJECT);
        this.name = Util.checkNotNull(name, "name == null", new Object[0]);
        this.bounds = Collections.unmodifiableList(boundsNoObject);
        for (TypeName bound : this.bounds) {
            Util.checkArgument(!bound.isPrimitive() && bound != VOID, "invalid bound: %s", bound);
        }
    }

    public boolean equals(Object o) {
        return o instanceof TypeVariableName && ((TypeVariableName)o).name.equals(this.name) && ((TypeVariableName)o).bounds.equals(this.bounds);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.bounds.hashCode();
    }

    @Override
    CodeWriter emit(CodeWriter out) throws IOException {
        return out.emitAndIndent(this.name);
    }

    public static TypeVariableName get(String name) {
        return new TypeVariableName(name, Collections.emptyList());
    }

    public static TypeVariableName get(String name, TypeName ... bounds) {
        return new TypeVariableName(name, Arrays.asList(bounds));
    }

    public static TypeVariableName get(String name, Type ... bounds) {
        return new TypeVariableName(name, TypeName.list(bounds));
    }

    public static TypeVariableName get(javax.lang.model.type.TypeVariable mirror) {
        String name = mirror.asElement().getSimpleName().toString();
        List<? extends TypeMirror> boundsMirrors = TypeVariableName.typeVariableBounds(mirror);
        ArrayList<TypeName> boundsTypeNames = new ArrayList<TypeName>();
        for (TypeMirror typeMirror : boundsMirrors) {
            boundsTypeNames.add(TypeName.get(typeMirror));
        }
        return new TypeVariableName(name, boundsTypeNames);
    }

    private static List<? extends TypeMirror> typeVariableBounds(javax.lang.model.type.TypeVariable typeVariable) {
        TypeElement upperBoundElement;
        TypeMirror upperBound = typeVariable.getUpperBound();
        if ("INTERSECTION".equals(upperBound.getKind().name())) {
            try {
                Method method = upperBound.getClass().getMethod("getBounds", new Class[0]);
                return (List)method.invoke((Object)upperBound, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (upperBound.getKind() == TypeKind.DECLARED && (upperBoundElement = (TypeElement)((DeclaredType)upperBound).asElement()).getNestingKind() == NestingKind.ANONYMOUS) {
            ArrayList<? extends TypeMirror> result = new ArrayList<TypeMirror>();
            result.add(upperBoundElement.getSuperclass());
            result.addAll(upperBoundElement.getInterfaces());
            return result;
        }
        return Collections.singletonList(upperBound);
    }

    public static TypeVariableName get(TypeVariable<?> type) {
        return new TypeVariableName(type.getName(), TypeName.list(type.getBounds()));
    }
}

