/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CodeBlock {
    final List<String> formatParts;
    final List<Object> args;

    private CodeBlock(Builder builder) {
        this.formatParts = Util.immutableList(builder.formatParts);
        this.args = Util.immutableList(builder.args);
    }

    public boolean isEmpty() {
        return this.formatParts.isEmpty();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            new CodeWriter(out).emit(this);
            return out.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        final List<String> formatParts = new ArrayList<String>();
        final List<Object> args = new ArrayList<Object>();

        private Builder() {
        }

        public Builder add(String format, Object ... args) {
            int expectedArgsLength = 0;
            int p = 0;
            while (p < format.length()) {
                int nextP;
                if (format.charAt(p) != '$') {
                    nextP = format.indexOf(36, p + 1);
                    if (nextP == -1) {
                        nextP = format.length();
                    }
                } else {
                    Util.checkState(p + 1 < format.length(), "dangling $ in format string %s", format);
                    switch (format.charAt(p + 1)) {
                        case 'L': 
                        case 'N': 
                        case 'S': 
                        case 'T': {
                            ++expectedArgsLength;
                        }
                        case '$': 
                        case '<': 
                        case '>': 
                        case '[': 
                        case ']': {
                            nextP = p + 2;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid format string: " + format);
                        }
                    }
                }
                this.formatParts.add(format.substring(p, nextP));
                p = nextP;
            }
            Util.checkArgument(args.length == expectedArgsLength, "expected %s args for %s but was %s", expectedArgsLength, format, args.length);
            Collections.addAll(this.args, args);
            return this;
        }

        public Builder beginControlFlow(String controlFlow, Object ... args) {
            this.add(controlFlow + " {\n", args);
            this.indent();
            return this;
        }

        public Builder nextControlFlow(String controlFlow, Object ... args) {
            this.unindent();
            this.add("} ", args);
            this.add(controlFlow, args);
            this.add("{\n", args);
            this.indent();
            return this;
        }

        public Builder endControlFlow() {
            this.unindent();
            this.add("}\n", new Object[0]);
            return this;
        }

        public Builder endControlFlow(String controlFlow, Object ... args) {
            this.unindent();
            this.add("} " + controlFlow + ";\n", args);
            return this;
        }

        public Builder addStatement(String format, Object ... args) {
            this.add("$[", new Object[0]);
            this.add(format, args);
            this.add(";\n$]", new Object[0]);
            return this;
        }

        public Builder add(CodeBlock codeBlock) {
            this.formatParts.addAll(codeBlock.formatParts);
            this.args.addAll(codeBlock.args);
            return this;
        }

        public Builder indent() {
            this.formatParts.add("$>");
            return this;
        }

        public Builder unindent() {
            this.formatParts.add("$<");
            return this;
        }

        public CodeBlock build() {
            return new CodeBlock(this);
        }
    }
}

