/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.HasData;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColumnSortEvent
extends GwtEvent<Handler> {
    private static GwtEvent.Type<Handler> TYPE;
    private final ColumnSortList sortList;

    public static ColumnSortEvent fire(HasHandlers source, ColumnSortList sortList) {
        ColumnSortEvent event = new ColumnSortEvent(sortList);
        if (TYPE != null) {
            source.fireEvent(event);
        }
        return event;
    }

    public static GwtEvent.Type<Handler> getType() {
        if (TYPE == null) {
            TYPE = new GwtEvent.Type();
        }
        return TYPE;
    }

    protected ColumnSortEvent(ColumnSortList sortList) {
        this.sortList = sortList;
    }

    @Override
    public GwtEvent.Type<Handler> getAssociatedType() {
        return TYPE;
    }

    public Column<?, ?> getColumn() {
        return this.sortList == null || this.sortList.size() == 0 ? null : this.sortList.get(0).getColumn();
    }

    public ColumnSortList getColumnSortList() {
        return this.sortList;
    }

    public boolean isSortAscending() {
        return this.sortList == null || this.sortList.size() == 0 ? false : this.sortList.get(0).isAscending();
    }

    @Override
    protected void dispatch(Handler handler) {
        handler.onColumnSort(this);
    }

    public static interface Handler
    extends EventHandler {
        public void onColumnSort(ColumnSortEvent var1);
    }

    public static class ListHandler<T>
    implements Handler {
        private final Map<Column<?, ?>, Comparator<T>> comparators = new HashMap();
        private List<T> list;

        public ListHandler(List<T> list) {
            this.list = list;
        }

        public Comparator<T> getComparator(Column<T, ?> column) {
            return this.comparators.get(column);
        }

        public List<T> getList() {
            return this.list;
        }

        @Override
        public void onColumnSort(ColumnSortEvent event) {
            Column<?, ?> column = event.getColumn();
            if (column == null) {
                return;
            }
            final Comparator<T> comparator = this.comparators.get(column);
            if (comparator == null) {
                return;
            }
            if (event.isSortAscending()) {
                Collections.sort(this.list, comparator);
            } else {
                Collections.sort(this.list, new Comparator<T>(){

                    @Override
                    public int compare(T o1, T o2) {
                        return -comparator.compare(o1, o2);
                    }
                });
            }
        }

        public void setComparator(Column<T, ?> column, Comparator<T> comparator) {
            this.comparators.put(column, comparator);
        }

        public void setList(List<T> list) {
            assert (list != null) : "list cannot be null";
            this.list = list;
        }
    }

    public static class AsyncHandler
    implements Handler {
        private final HasData<?> hasData;

        public AsyncHandler(HasData<?> hasData) {
            this.hasData = hasData;
        }

        @Override
        public void onColumnSort(ColumnSortEvent event) {
            this.hasData.setVisibleRangeAndClearData(this.hasData.getVisibleRange(), true);
        }
    }
}

