/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.StringUtils;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.internal.CryptoSigner;
import com.google.firebase.internal.FirebaseRequestInitializer;
import com.google.firebase.internal.NonNull;
import java.io.IOException;
import java.io.InputStream;

public class CryptoSigners {
    private static final String METADATA_SERVICE_URL = "http://metadata/computeMetadata/v1/instance/service-accounts/default/email";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoSigner getCryptoSigner(FirebaseApp firebaseApp) throws IOException {
        GoogleCredentials credentials = ImplFirebaseTrampolines.getCredentials(firebaseApp);
        if (credentials instanceof ServiceAccountCredentials) {
            return new ServiceAccountCryptoSigner((ServiceAccountSigner)((ServiceAccountCredentials)credentials));
        }
        FirebaseOptions options = firebaseApp.getOptions();
        HttpRequestFactory requestFactory = options.getHttpTransport().createRequestFactory((HttpRequestInitializer)new FirebaseRequestInitializer(firebaseApp));
        JsonFactory jsonFactory = options.getJsonFactory();
        String serviceAccountId = options.getServiceAccountId();
        if (!Strings.isNullOrEmpty((String)serviceAccountId)) {
            return new IAMCryptoSigner(requestFactory, jsonFactory, serviceAccountId);
        }
        if (credentials instanceof ServiceAccountSigner) {
            return new ServiceAccountCryptoSigner((ServiceAccountSigner)credentials);
        }
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(METADATA_SERVICE_URL));
        request.getHeaders().set("Metadata-Flavor", (Object)"Google");
        HttpResponse response = request.execute();
        try {
            byte[] output = ByteStreams.toByteArray((InputStream)response.getContent());
            serviceAccountId = StringUtils.newStringUtf8((byte[])output).trim();
            IAMCryptoSigner iAMCryptoSigner = new IAMCryptoSigner(requestFactory, jsonFactory, serviceAccountId);
            return iAMCryptoSigner;
        }
        finally {
            response.disconnect();
        }
    }

    public static class SignBlobResponse {
        @Key(value="signature")
        private String signature;
    }

    static class IAMCryptoSigner
    implements CryptoSigner {
        private static final String IAM_SIGN_BLOB_URL = "https://iam.googleapis.com/v1/projects/-/serviceAccounts/%s:signBlob";
        private final HttpRequestFactory requestFactory;
        private final JsonFactory jsonFactory;
        private final String serviceAccount;
        private HttpResponseInterceptor interceptor;

        IAMCryptoSigner(@NonNull HttpRequestFactory requestFactory, @NonNull JsonFactory jsonFactory, @NonNull String serviceAccount) {
            this.requestFactory = (HttpRequestFactory)Preconditions.checkNotNull((Object)requestFactory);
            this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceAccount) ? 1 : 0) != 0);
            this.serviceAccount = serviceAccount;
        }

        void setInterceptor(HttpResponseInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] sign(byte[] payload) throws IOException {
            String encodedUrl = String.format(IAM_SIGN_BLOB_URL, this.serviceAccount);
            HttpResponse response = null;
            String encodedPayload = BaseEncoding.base64().encode(payload);
            ImmutableMap content = ImmutableMap.of((Object)"bytesToSign", (Object)encodedPayload);
            try {
                HttpRequest request = this.requestFactory.buildPostRequest(new GenericUrl(encodedUrl), (HttpContent)new JsonHttpContent(this.jsonFactory, (Object)content));
                request.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
                request.setResponseInterceptor(this.interceptor);
                response = request.execute();
                SignBlobResponse parsed = (SignBlobResponse)response.parseAs(SignBlobResponse.class);
                byte[] byArray = BaseEncoding.base64().decode((CharSequence)parsed.signature);
                return byArray;
            }
            finally {
                if (response != null) {
                    try {
                        response.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public String getAccount() {
            return this.serviceAccount;
        }
    }

    static class ServiceAccountCryptoSigner
    implements CryptoSigner {
        private final ServiceAccountSigner signer;

        ServiceAccountCryptoSigner(@NonNull ServiceAccountSigner signer) {
            this.signer = (ServiceAccountSigner)Preconditions.checkNotNull((Object)signer);
        }

        @Override
        public byte[] sign(byte[] payload) {
            return this.signer.sign(payload);
        }

        @Override
        public String getAccount() {
            return this.signer.getAccount();
        }
    }
}

