/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public final class TypeSpec {
    public final Kind kind;
    public final String name;
    public final CodeBlock anonymousTypeArguments;
    public final CodeBlock javadoc;
    public final List<AnnotationSpec> annotations;
    public final Set<Modifier> modifiers;
    public final List<TypeVariableName> typeVariables;
    public final TypeName superclass;
    public final List<TypeName> superinterfaces;
    public final Map<String, TypeSpec> enumConstants;
    public final List<FieldSpec> fieldSpecs;
    public final List<MethodSpec> methodSpecs;
    public final List<TypeSpec> typeSpecs;
    public final List<Element> originatingElements;

    private TypeSpec(Builder builder) {
        this.kind = builder.kind;
        this.name = builder.name;
        this.anonymousTypeArguments = builder.anonymousTypeArguments;
        this.javadoc = builder.javadoc.build();
        this.annotations = Util.immutableList(builder.annotations);
        this.modifiers = Util.immutableSet(builder.modifiers);
        this.typeVariables = Util.immutableList(builder.typeVariables);
        this.superclass = builder.superclass;
        this.superinterfaces = Util.immutableList(builder.superinterfaces);
        this.enumConstants = Util.immutableMap(builder.enumConstants);
        this.fieldSpecs = Util.immutableList(builder.fieldSpecs);
        this.methodSpecs = Util.immutableList(builder.methodSpecs);
        this.typeSpecs = Util.immutableList(builder.typeSpecs);
        ArrayList<Element> originatingElementsMutable = new ArrayList<Element>();
        originatingElementsMutable.addAll(builder.originatingElements);
        for (TypeSpec typeSpec : builder.typeSpecs) {
            originatingElementsMutable.addAll(typeSpec.originatingElements);
        }
        this.originatingElements = Util.immutableList(originatingElementsMutable);
    }

    public boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public static Builder classBuilder(String name) {
        return new Builder(Kind.CLASS, Util.checkNotNull(name, "name == null", new Object[0]), null);
    }

    public static Builder interfaceBuilder(String name) {
        return new Builder(Kind.INTERFACE, Util.checkNotNull(name, "name == null", new Object[0]), null);
    }

    public static Builder enumBuilder(String name) {
        return new Builder(Kind.ENUM, Util.checkNotNull(name, "name == null", new Object[0]), null);
    }

    public static Builder anonymousClassBuilder(String typeArgumentsFormat, Object ... args) {
        return new Builder(Kind.CLASS, null, CodeBlock.builder().add(typeArgumentsFormat, args).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emit(CodeWriter codeWriter, String enumName, Set<Modifier> implicitModifiers) throws IOException {
        int previousStatementLine = codeWriter.statementLine;
        codeWriter.statementLine = -1;
        try {
            if (enumName != null) {
                codeWriter.emit("$L", enumName);
                if (!this.anonymousTypeArguments.formatParts.isEmpty()) {
                    codeWriter.emit("(", new Object[0]);
                    codeWriter.emit(this.anonymousTypeArguments);
                    codeWriter.emit(")", new Object[0]);
                }
                if (this.fieldSpecs.isEmpty() && this.methodSpecs.isEmpty() && this.typeSpecs.isEmpty()) {
                    return;
                }
                codeWriter.emit(" {\n", new Object[0]);
            } else if (this.anonymousTypeArguments != null) {
                TypeName supertype = !this.superinterfaces.isEmpty() ? this.superinterfaces.get(0) : this.superclass;
                codeWriter.emit("new $T(", supertype);
                codeWriter.emit(this.anonymousTypeArguments);
                codeWriter.emit(") {\n", new Object[0]);
            } else {
                boolean firstType;
                List<Object> implementsTypes;
                List<TypeName> extendsTypes;
                codeWriter.emitJavadoc(this.javadoc);
                codeWriter.emitAnnotations(this.annotations, false);
                codeWriter.emitModifiers(this.modifiers, Util.union(implicitModifiers, this.kind.asMemberModifiers));
                codeWriter.emit("$L $L", this.kind.name().toLowerCase(Locale.US), this.name);
                codeWriter.emitTypeVariables(this.typeVariables);
                if (this.kind == Kind.INTERFACE) {
                    extendsTypes = this.superinterfaces;
                    implementsTypes = Collections.emptyList();
                } else {
                    extendsTypes = this.superclass.equals(ClassName.OBJECT) ? Collections.emptyList() : Collections.singletonList(this.superclass);
                    implementsTypes = this.superinterfaces;
                }
                if (!extendsTypes.isEmpty()) {
                    codeWriter.emit(" extends", new Object[0]);
                    firstType = true;
                    for (TypeName typeName : extendsTypes) {
                        if (!firstType) {
                            codeWriter.emit(",", new Object[0]);
                        }
                        codeWriter.emit(" $T", typeName);
                        firstType = false;
                    }
                }
                if (!implementsTypes.isEmpty()) {
                    codeWriter.emit(" implements", new Object[0]);
                    firstType = true;
                    for (TypeName typeName : implementsTypes) {
                        if (!firstType) {
                            codeWriter.emit(",", new Object[0]);
                        }
                        codeWriter.emit(" $T", typeName);
                        firstType = false;
                    }
                }
                codeWriter.emit(" {\n", new Object[0]);
            }
            codeWriter.pushType(this);
            codeWriter.indent();
            boolean firstMember = true;
            Iterator<Map.Entry<String, TypeSpec>> i = this.enumConstants.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, TypeSpec> enumConstant = i.next();
                if (!firstMember) {
                    codeWriter.emit("\n", new Object[0]);
                }
                enumConstant.getValue().emit(codeWriter, enumConstant.getKey(), Collections.emptySet());
                firstMember = false;
                if (i.hasNext()) {
                    codeWriter.emit(",\n", new Object[0]);
                    continue;
                }
                if (!(this.fieldSpecs.isEmpty() && this.methodSpecs.isEmpty() && this.typeSpecs.isEmpty())) {
                    codeWriter.emit(";\n", new Object[0]);
                    continue;
                }
                codeWriter.emit("\n", new Object[0]);
            }
            for (FieldSpec fieldSpec : this.fieldSpecs) {
                if (!fieldSpec.hasModifier(Modifier.STATIC)) continue;
                if (!firstMember) {
                    codeWriter.emit("\n", new Object[0]);
                }
                fieldSpec.emit(codeWriter, this.kind.implicitFieldModifiers);
                firstMember = false;
            }
            for (FieldSpec fieldSpec : this.fieldSpecs) {
                if (fieldSpec.hasModifier(Modifier.STATIC)) continue;
                if (!firstMember) {
                    codeWriter.emit("\n", new Object[0]);
                }
                fieldSpec.emit(codeWriter, this.kind.implicitFieldModifiers);
                firstMember = false;
            }
            for (MethodSpec methodSpec : this.methodSpecs) {
                if (!methodSpec.isConstructor()) continue;
                if (!firstMember) {
                    codeWriter.emit("\n", new Object[0]);
                }
                methodSpec.emit(codeWriter, this.name, this.kind.implicitMethodModifiers);
                firstMember = false;
            }
            for (MethodSpec methodSpec : this.methodSpecs) {
                if (methodSpec.isConstructor()) continue;
                if (!firstMember) {
                    codeWriter.emit("\n", new Object[0]);
                }
                methodSpec.emit(codeWriter, this.name, this.kind.implicitMethodModifiers);
                firstMember = false;
            }
            for (TypeSpec typeSpec : this.typeSpecs) {
                if (!firstMember) {
                    codeWriter.emit("\n", new Object[0]);
                }
                typeSpec.emit(codeWriter, null, this.kind.implicitTypeModifiers);
                firstMember = false;
            }
            codeWriter.unindent();
            codeWriter.popType();
            codeWriter.emit("}", new Object[0]);
            if (enumName == null && this.anonymousTypeArguments == null) {
                codeWriter.emit("\n", new Object[0]);
            }
        }
        finally {
            codeWriter.statementLine = previousStatementLine;
        }
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            CodeWriter codeWriter = new CodeWriter(out);
            this.emit(codeWriter, null, Collections.emptySet());
            return out.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static final class Builder {
        private final Kind kind;
        private final String name;
        private final CodeBlock anonymousTypeArguments;
        private final CodeBlock.Builder javadoc = CodeBlock.builder();
        private final List<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
        private final List<Modifier> modifiers = new ArrayList<Modifier>();
        private final List<TypeVariableName> typeVariables = new ArrayList<TypeVariableName>();
        private TypeName superclass = ClassName.OBJECT;
        private final List<TypeName> superinterfaces = new ArrayList<TypeName>();
        private final Map<String, TypeSpec> enumConstants = new LinkedHashMap<String, TypeSpec>();
        private final List<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
        private final List<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        private final List<TypeSpec> typeSpecs = new ArrayList<TypeSpec>();
        private final List<Element> originatingElements = new ArrayList<Element>();

        private Builder(Kind kind, String name, CodeBlock anonymousTypeArguments) {
            Util.checkArgument(name == null || SourceVersion.isName(name), "not a valid name: %s", name);
            this.kind = kind;
            this.name = name;
            this.anonymousTypeArguments = anonymousTypeArguments;
        }

        public Builder addJavadoc(String format, Object ... args) {
            Util.checkState(this.anonymousTypeArguments == null, "forbidden on anonymous types.", new Object[0]);
            this.javadoc.add(format, args);
            return this;
        }

        public Builder addAnnotation(AnnotationSpec annotationSpec) {
            Util.checkState(this.anonymousTypeArguments == null, "forbidden on anonymous types.", new Object[0]);
            this.annotations.add(annotationSpec);
            return this;
        }

        public Builder addAnnotation(ClassName annotation) {
            return this.addAnnotation(AnnotationSpec.builder(annotation).build());
        }

        public Builder addAnnotation(Class<?> annotation) {
            return this.addAnnotation(ClassName.get(annotation));
        }

        public Builder addModifiers(Modifier ... modifiers) {
            Util.checkState(this.anonymousTypeArguments == null, "forbidden on anonymous types.", new Object[0]);
            Collections.addAll(this.modifiers, modifiers);
            return this;
        }

        public Builder addTypeVariable(TypeVariableName typeVariable) {
            Util.checkState(this.anonymousTypeArguments == null, "forbidden on anonymous types.", new Object[0]);
            this.typeVariables.add(typeVariable);
            return this;
        }

        public Builder superclass(TypeName superclass) {
            this.superclass = superclass;
            return this;
        }

        public Builder superclass(Type superclass) {
            return this.superclass(TypeName.get(superclass));
        }

        public Builder addSuperinterface(TypeName superinterface) {
            this.superinterfaces.add(superinterface);
            return this;
        }

        public Builder addSuperinterface(Type superinterface) {
            return this.addSuperinterface(TypeName.get(superinterface));
        }

        public Builder addEnumConstant(String name) {
            return this.addEnumConstant(name, TypeSpec.anonymousClassBuilder("", new Object[0]).build());
        }

        public Builder addEnumConstant(String name, TypeSpec typeSpec) {
            Util.checkState(this.kind == Kind.ENUM, "%s is not enum", this.name);
            Util.checkArgument(typeSpec.anonymousTypeArguments != null, "enum constants must have anonymous type arguments", new Object[0]);
            Util.checkArgument(SourceVersion.isName(name), "not a valid enum constant: %s", name);
            this.enumConstants.put(name, typeSpec);
            return this;
        }

        public Builder addField(FieldSpec fieldSpec) {
            Util.checkArgument(fieldSpec.modifiers.containsAll(this.kind.implicitFieldModifiers), "%s %s.%s requires modifiers %s", new Object[]{this.kind, this.name, fieldSpec.name, this.kind.implicitFieldModifiers});
            this.fieldSpecs.add(fieldSpec);
            return this;
        }

        public Builder addField(TypeName type, String name, Modifier ... modifiers) {
            return this.addField(FieldSpec.builder(type, name, modifiers).build());
        }

        public Builder addField(Type type, String name, Modifier ... modifiers) {
            return this.addField(TypeName.get(type), name, modifiers);
        }

        public Builder addMethod(MethodSpec methodSpec) {
            Util.checkArgument(methodSpec.modifiers.containsAll(this.kind.implicitMethodModifiers), "%s %s.%s requires modifiers %s", new Object[]{this.kind, this.name, methodSpec.name, this.kind.implicitMethodModifiers});
            this.methodSpecs.add(methodSpec);
            return this;
        }

        public Builder addType(TypeSpec typeSpec) {
            Util.checkArgument(typeSpec.modifiers.containsAll(this.kind.implicitTypeModifiers), "%s %s.%s requires modifiers %s", new Object[]{this.kind, this.name, typeSpec.name, this.kind.implicitFieldModifiers});
            this.typeSpecs.add(typeSpec);
            return this;
        }

        public Builder addOriginatingElement(Element originatingElement) {
            this.originatingElements.add(originatingElement);
            return this;
        }

        public TypeSpec build() {
            Util.checkArgument(this.kind != Kind.ENUM || !this.enumConstants.isEmpty(), "at least one enum constant is required for %s", this.name);
            boolean isAbstract = this.modifiers.contains((Object)Modifier.ABSTRACT) || this.kind != Kind.CLASS;
            for (MethodSpec methodSpec : this.methodSpecs) {
                Util.checkArgument(isAbstract || !methodSpec.hasModifier(Modifier.ABSTRACT), "non-abstract type %s cannot declare abstract method %s", this.name, methodSpec.name);
            }
            boolean superclassIsObject = this.superclass.equals(ClassName.OBJECT);
            int interestingSupertypeCount = (superclassIsObject ? 0 : 1) + this.superinterfaces.size();
            Util.checkArgument(this.anonymousTypeArguments == null || interestingSupertypeCount <= 1, "anonymous type has too many supertypes", new Object[0]);
            return new TypeSpec(this);
        }
    }

    private static enum Kind {
        CLASS(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet()),
        INTERFACE(Util.immutableSet(Arrays.asList(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL)), Util.immutableSet(Arrays.asList(Modifier.PUBLIC, Modifier.ABSTRACT)), Util.immutableSet(Arrays.asList(Modifier.PUBLIC, Modifier.STATIC)), Util.immutableSet(Arrays.asList(Modifier.STATIC))),
        ENUM(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.singleton(Modifier.STATIC));

        private final Set<Modifier> implicitFieldModifiers;
        private final Set<Modifier> implicitMethodModifiers;
        private final Set<Modifier> implicitTypeModifiers;
        private final Set<Modifier> asMemberModifiers;

        private Kind(Set<Modifier> implicitFieldModifiers, Set<Modifier> implicitMethodModifiers, Set<Modifier> implicitTypeModifiers, Set<Modifier> asMemberModifiers) {
            this.implicitFieldModifiers = implicitFieldModifiers;
            this.implicitMethodModifiers = implicitMethodModifiers;
            this.implicitTypeModifiers = implicitTypeModifiers;
            this.asMemberModifiers = asMemberModifiers;
        }
    }
}

