/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.Util;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public final class JavaFile {
    private static final Appendable NULL_APPENDABLE = new Appendable(){

        @Override
        public Appendable append(CharSequence charSequence) {
            return this;
        }

        @Override
        public Appendable append(CharSequence charSequence, int start, int end) {
            return this;
        }

        @Override
        public Appendable append(char c) {
            return this;
        }
    };
    public final CodeBlock fileComment;
    public final String packageName;
    public final TypeSpec typeSpec;
    public final boolean skipJavaLangImports;
    private final String indent;

    private JavaFile(Builder builder) {
        this.fileComment = builder.fileComment.build();
        this.packageName = builder.packageName;
        this.typeSpec = builder.typeSpec;
        this.skipJavaLangImports = builder.skipJavaLangImports;
        this.indent = builder.indent;
    }

    public void writeTo(Appendable out) throws IOException {
        CodeWriter importsCollector = new CodeWriter(NULL_APPENDABLE, this.indent);
        this.emit(importsCollector);
        Map<ClassName, String> suggestedImports = importsCollector.suggestedImports();
        CodeWriter codeWriter = new CodeWriter(out, this.indent, suggestedImports);
        this.emit(codeWriter);
    }

    public void writeTo(Path directory) throws IOException {
        Util.checkArgument(Files.notExists(directory, new LinkOption[0]) || Files.isDirectory(directory, new LinkOption[0]), "path %s exists but is not a directory.", directory);
        Path outputDirectory = directory;
        if (!this.packageName.isEmpty()) {
            for (String packageComponent : this.packageName.split("\\.")) {
                outputDirectory = outputDirectory.resolve(packageComponent);
            }
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
        }
        Path outputPath = outputDirectory.resolve(this.typeSpec.name + ".java");
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(outputPath, new OpenOption[0]));){
            this.writeTo(writer);
        }
    }

    public void writeTo(File directory) throws IOException {
        this.writeTo(directory.toPath());
    }

    public void writeTo(Filer filer) throws IOException {
        String fileName = this.packageName.isEmpty() ? this.typeSpec.name : this.packageName + "." + this.typeSpec.name;
        List<Element> originatingElements = this.typeSpec.originatingElements;
        JavaFileObject filerSourceFile = filer.createSourceFile(fileName, originatingElements.toArray(new Element[originatingElements.size()]));
        try (Writer writer = filerSourceFile.openWriter();){
            this.writeTo(writer);
        }
        catch (Exception e) {
            try {
                filerSourceFile.delete();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw e;
        }
    }

    private void emit(CodeWriter codeWriter) throws IOException {
        codeWriter.pushPackage(this.packageName);
        if (!this.fileComment.isEmpty()) {
            codeWriter.emitComment(this.fileComment);
        }
        if (!this.packageName.isEmpty()) {
            codeWriter.emit("package $L;\n", this.packageName);
            codeWriter.emit("\n", new Object[0]);
        }
        int importedTypesCount = 0;
        for (ClassName className : codeWriter.importedTypes().keySet()) {
            if (this.skipJavaLangImports && className.packageName().equals("java.lang")) continue;
            codeWriter.emit("import $L;\n", className);
            ++importedTypesCount;
        }
        if (importedTypesCount > 0) {
            codeWriter.emit("\n", new Object[0]);
        }
        this.typeSpec.emit(codeWriter, null, Collections.emptySet());
        codeWriter.popPackage();
    }

    public String toString() {
        try {
            StringBuilder result = new StringBuilder();
            this.writeTo(result);
            return result.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static Builder builder(String packageName, TypeSpec typeSpec) {
        Util.checkNotNull(packageName, "packageName == null", new Object[0]);
        Util.checkNotNull(typeSpec, "typeSpec == null", new Object[0]);
        return new Builder(packageName, typeSpec);
    }

    public static final class Builder {
        private final String packageName;
        private final TypeSpec typeSpec;
        private CodeBlock.Builder fileComment = CodeBlock.builder();
        private boolean skipJavaLangImports;
        private String indent = "  ";

        private Builder(String packageName, TypeSpec typeSpec) {
            this.packageName = packageName;
            this.typeSpec = typeSpec;
        }

        public Builder addFileComment(String format, Object ... args) {
            this.fileComment.add(format, args);
            return this;
        }

        public Builder skipJavaLangImports(boolean skipJavaLangImports) {
            this.skipJavaLangImports = skipJavaLangImports;
            return this;
        }

        public Builder indent(String indent) {
            this.indent = indent;
            return this;
        }

        public JavaFile build() {
            return new JavaFile(this);
        }
    }
}

