/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.server.ArrayBufferViewImpl;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.DataView;

public class DataViewImpl
extends ArrayBufferViewImpl
implements DataView {
    public DataViewImpl(ArrayBuffer buffer, int byteOffset, int byteLength) {
        super(buffer, byteOffset, byteLength);
    }

    @Override
    public float getFloat32(int byteOffset) {
        return this.getFloat32(byteOffset, false);
    }

    @Override
    public float getFloat32(int byteOffset, boolean littleEndian) {
        return this.arrayBuf.getFloat32(byteOffset, littleEndian);
    }

    @Override
    public double getFloat64(int byteOffset) {
        return this.getFloat64(byteOffset, false);
    }

    @Override
    public double getFloat64(int byteOffset, boolean littleEndian) {
        return this.arrayBuf.getFloat64(byteOffset, littleEndian);
    }

    @Override
    public short getInt16(int byteOffset) {
        return this.getInt16(byteOffset, false);
    }

    @Override
    public short getInt16(int byteOffset, boolean littleEndian) {
        return this.arrayBuf.getInt16(byteOffset, littleEndian);
    }

    @Override
    public int getInt32(int byteOffset) {
        return this.getInt32(byteOffset, false);
    }

    @Override
    public int getInt32(int byteOffset, boolean littleEndian) {
        return this.arrayBuf.getInt32(byteOffset, littleEndian);
    }

    @Override
    public byte getInt8(int byteOffset) {
        return this.arrayBuf.getInt8(byteOffset);
    }

    @Override
    public int getUint16(int byteOffset) {
        return this.getUint16(byteOffset, false);
    }

    @Override
    public int getUint16(int byteOffset, boolean littleEndian) {
        int val = this.arrayBuf.getInt16(byteOffset, littleEndian);
        if (val < 0) {
            val += 65536;
        }
        return val;
    }

    @Override
    public long getUint32(int byteOffset) {
        return this.getUint32(byteOffset, false);
    }

    @Override
    public long getUint32(int byteOffset, boolean littleEndian) {
        long val = this.arrayBuf.getInt32(byteOffset, littleEndian);
        if (val < 0L) {
            val += 0x100000000L;
        }
        return val;
    }

    @Override
    public double getUint32AsDouble(int byteOffset) {
        return this.getUint32(byteOffset, false);
    }

    @Override
    public double getUint32AsDouble(int byteOffset, boolean littleEndian) {
        return this.getUint32(byteOffset, littleEndian);
    }

    @Override
    public short getUint8(int byteOffset) {
        short val = this.getInt8(byteOffset);
        if (val < 0) {
            val = (short)(val + 256);
        }
        return val;
    }

    @Override
    public void setFloat32(int byteOffset, float value) {
        this.setFloat32(byteOffset, value, false);
    }

    @Override
    public void setFloat32(int byteOffset, float value, boolean littleEndian) {
        this.arrayBuf.setFloat32(byteOffset, value, littleEndian);
    }

    @Override
    public void setFloat64(int byteOffset, double value) {
        this.setFloat64(byteOffset, value, false);
    }

    @Override
    public void setFloat64(int byteOffset, double value, boolean littleEndian) {
        this.arrayBuf.setFloat64(byteOffset, value, littleEndian);
    }

    @Override
    public void setInt16(int byteOffset, int value) {
        this.setInt16(byteOffset, value, false);
    }

    @Override
    public void setInt16(int byteOffset, int value, boolean littleEndian) {
        this.arrayBuf.setInt16(byteOffset, (short)(value & 0xFFFF), littleEndian);
    }

    @Override
    public void setInt32(int byteOffset, int value) {
        this.setInt32(byteOffset, value, false);
    }

    @Override
    public void setInt32(int byteOffset, int value, boolean littleEndian) {
        this.arrayBuf.setInt32(byteOffset, value, littleEndian);
    }

    @Override
    public void setInt8(int byteOffset, int value) {
        this.arrayBuf.setInt8(byteOffset, (byte)(value & 0xFF));
    }

    @Override
    public void setUint16(int byteOffset, int value) {
        this.setUint16(byteOffset, value, false);
    }

    @Override
    public void setUint16(int byteOffset, int value, boolean littleEndian) {
        this.arrayBuf.setInt16(byteOffset, (short)(value & 0xFFFF), littleEndian);
    }

    @Override
    public void setUint32(int byteOffset, long value) {
        this.setUint32(byteOffset, value, false);
    }

    @Override
    public void setUint32(int byteOffset, long value, boolean littleEndian) {
        this.arrayBuf.setInt32(byteOffset, (int)(value & 0xFFFFFFFFFFFFFFFFL), littleEndian);
    }

    @Override
    public void setUint32FromDouble(int byteOffset, double value) {
        this.setUint32(byteOffset, (long)value);
    }

    @Override
    public void setUint32FromDouble(int byteOffset, double value, boolean littleEndian) {
        this.setUint32(byteOffset, (long)value, littleEndian);
    }

    @Override
    public void setUint8(int byteOffset, int value) {
        this.arrayBuf.setInt8(byteOffset, (byte)(value & 0xFF));
    }
}

