/*
 * Copyright (C) 2000 - 2022 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception.  You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.silverpeas.mobile.shared.services.rest;

import org.fusesource.restygwt.client.MethodCallback;
import org.fusesource.restygwt.client.RestService;
import org.silverpeas.mobile.shared.StreamingList;
import org.silverpeas.mobile.shared.dto.BaseDTO;
import org.silverpeas.mobile.shared.dto.workflow.WorkflowDataDTO;
import org.silverpeas.mobile.shared.dto.workflow.WorkflowFormActionDTO;
import org.silverpeas.mobile.shared.dto.workflow.WorkflowInstanceDTO;
import org.silverpeas.mobile.shared.dto.workflow.WorkflowInstancePresentationFormDTO;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

@Path("/mobile/workflow")
public interface ServiceWorkflow extends RestService {

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Path("{appId}/userField/{instanceId}/{actionName}/{fieldName}/{role}")
  void getUserField(@PathParam("appId") String appId, @PathParam("instanceId") String instanceId,
      @PathParam("actionName") String actionName, @PathParam("fieldName") String fieldName,
      @PathParam("role") String role, MethodCallback<List<BaseDTO>> callback);

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Path("{appId}/instances/{role}/{callNumber}")
  void getWorkflowInstances(@PathParam("appId") String appId, @PathParam("role") String userRole, @PathParam("callNumber") int callNumber, MethodCallback<StreamingList<WorkflowInstanceDTO>> callback);

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Path("{appId}/datainstances/{role}")
  void getDataInstances(@PathParam("appId") String appId, @PathParam("role") String userRole,
      MethodCallback<WorkflowDataDTO> callback);

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Path("{appId}/presentationForm/{instanceId}/{role}")
  void getPresentationForm(@PathParam("appId") String appId,
      @PathParam("instanceId") String instanceId, @PathParam("role") String role,
      MethodCallback<WorkflowInstancePresentationFormDTO> callback);

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Path("{appId}/actionForm/{instanceId}/{role}/{action}")
  void getActionForm(@PathParam("appId") String appId, @PathParam("instanceId") String instanceId, @PathParam("role") String role,
      @PathParam("action") String action, MethodCallback<WorkflowFormActionDTO> callback);
}
