/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor7;

public class TypeName {
    public static final TypeName VOID = new TypeName("void");
    public static final TypeName BOOLEAN = new TypeName("boolean");
    public static final TypeName BYTE = new TypeName("byte");
    public static final TypeName SHORT = new TypeName("short");
    public static final TypeName INT = new TypeName("int");
    public static final TypeName LONG = new TypeName("long");
    public static final TypeName CHAR = new TypeName("char");
    public static final TypeName FLOAT = new TypeName("float");
    public static final TypeName DOUBLE = new TypeName("double");
    public static final ClassName OBJECT = ClassName.get("java.lang", "Object", new String[0]);
    private final String keyword;

    private TypeName(String keyword) {
        this.keyword = keyword;
    }

    TypeName() {
        this(null);
    }

    public boolean isPrimitive() {
        return this.keyword != null && this != VOID;
    }

    public final String toString() {
        try {
            StringBuilder result = new StringBuilder();
            this.emit(new CodeWriter(result));
            return result.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    CodeWriter emit(CodeWriter out) throws IOException {
        if (this.keyword == null) {
            throw new AssertionError();
        }
        return out.emitAndIndent(this.keyword);
    }

    public static TypeName get(TypeMirror mirror) {
        return mirror.accept(new SimpleTypeVisitor7<TypeName, Void>(){

            @Override
            public TypeName visitPrimitive(PrimitiveType t, Void p) {
                switch (t.getKind()) {
                    case BOOLEAN: {
                        return BOOLEAN;
                    }
                    case BYTE: {
                        return BYTE;
                    }
                    case SHORT: {
                        return SHORT;
                    }
                    case INT: {
                        return INT;
                    }
                    case LONG: {
                        return LONG;
                    }
                    case CHAR: {
                        return CHAR;
                    }
                    case FLOAT: {
                        return FLOAT;
                    }
                    case DOUBLE: {
                        return DOUBLE;
                    }
                }
                throw new AssertionError();
            }

            @Override
            public TypeName visitDeclared(DeclaredType t, Void p) {
                ClassName rawType = ClassName.get((TypeElement)t.asElement());
                if (t.getTypeArguments().isEmpty()) {
                    return rawType;
                }
                ArrayList<TypeName> typeArgumentNames = new ArrayList<TypeName>();
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    typeArgumentNames.add(TypeName.get(typeMirror));
                }
                return new ParameterizedTypeName(rawType, typeArgumentNames);
            }

            @Override
            public ArrayTypeName visitArray(ArrayType t, Void p) {
                return ArrayTypeName.get(t);
            }

            @Override
            public TypeName visitTypeVariable(javax.lang.model.type.TypeVariable t, Void p) {
                return TypeVariableName.get(t);
            }

            @Override
            public TypeName visitWildcard(javax.lang.model.type.WildcardType t, Void p) {
                return WildcardTypeName.get(t);
            }

            @Override
            public TypeName visitNoType(NoType t, Void p) {
                if (t.getKind() == TypeKind.VOID) {
                    return VOID;
                }
                return (TypeName)super.visitUnknown(t, p);
            }

            @Override
            protected TypeName defaultAction(TypeMirror e, Void p) {
                throw new IllegalArgumentException("Unexpected type mirror: " + e);
            }
        }, null);
    }

    public static TypeName get(Type type) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (type == Void.TYPE) {
                return VOID;
            }
            if (type == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (type == Byte.TYPE) {
                return BYTE;
            }
            if (type == Short.TYPE) {
                return SHORT;
            }
            if (type == Integer.TYPE) {
                return INT;
            }
            if (type == Long.TYPE) {
                return LONG;
            }
            if (type == Character.TYPE) {
                return CHAR;
            }
            if (type == Float.TYPE) {
                return FLOAT;
            }
            if (type == Double.TYPE) {
                return DOUBLE;
            }
            if (classType.isArray()) {
                return ArrayTypeName.of(TypeName.get(classType.getComponentType()));
            }
            return ClassName.get(classType);
        }
        if (type instanceof ParameterizedType) {
            return ParameterizedTypeName.get((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return WildcardTypeName.get((WildcardType)type);
        }
        if (type instanceof TypeVariable) {
            return TypeVariableName.get((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return ArrayTypeName.get((GenericArrayType)type);
        }
        throw new IllegalArgumentException("unexpected type: " + type);
    }

    static List<TypeName> list(Type[] types) {
        ArrayList<TypeName> result = new ArrayList<TypeName>();
        for (Type type : types) {
            result.add(TypeName.get(type));
        }
        return result;
    }

    static TypeName arrayComponent(TypeName type) {
        return type instanceof ArrayTypeName ? ((ArrayTypeName)type).componentType : null;
    }
}

