/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import javax.lang.model.type.ArrayType;

public final class ArrayTypeName
extends TypeName {
    public final TypeName componentType;

    private ArrayTypeName(TypeName componentType) {
        this.componentType = Util.checkNotNull(componentType, "rawType == null", new Object[0]);
    }

    public boolean equals(Object o) {
        return o instanceof ArrayTypeName && ((ArrayTypeName)o).componentType.equals(this.componentType);
    }

    public int hashCode() {
        return 31 * this.componentType.hashCode();
    }

    @Override
    CodeWriter emit(CodeWriter out) throws IOException {
        return out.emit("$T[]", this.componentType);
    }

    public static ArrayTypeName of(TypeName componentType) {
        return new ArrayTypeName(componentType);
    }

    public static ArrayTypeName of(Type componentType) {
        return ArrayTypeName.of(TypeName.get(componentType));
    }

    public static ArrayTypeName get(ArrayType mirror) {
        return new ArrayTypeName(ArrayTypeName.get(mirror.getComponentType()));
    }

    public static ArrayTypeName get(GenericArrayType type) {
        return ArrayTypeName.of(ArrayTypeName.get(type.getGenericComponentType()));
    }
}

