/*
 * Copyright (C) 2000 - 2022 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception.  You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.silverpeas.mobile.client.components.base;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import org.silverpeas.mobile.client.SpMobil;
import org.silverpeas.mobile.client.components.UnorderedList;

/**
 * @author: svu
 */
public class ActionsMenu  extends Composite {

    interface ActionsMenuUiBinder extends UiBinder<Widget, ActionsMenu> {
    }

    private static ActionsMenuUiBinder uiBinder = GWT.create(ActionsMenuUiBinder.class);

    private ActionsList actionsShortcuts;
    @UiField HTMLPanel container;
    @UiField
    UnorderedList listActions;
    @UiField Button actions;

    public ActionsMenu() {
        initWidget(uiBinder.createAndBindUi(this));
        listActions.setId("action-bloc");
        actions.getElement().setId("action-button");
        container.getElement().setId("actions");
        listActions.getElement().addClassName("closed-qvf-menu");
    }

    public void setActionsShortcuts(ActionsList actionsShortcuts) {
        this.actionsShortcuts = actionsShortcuts;
        hide();
    }

    @UiHandler("actions")
    protected void showActions(ClickEvent event) {
        if (listActions.getElement().getClassName().equals("closed-qvf-menu")) {
            listActions.getElement().addClassName("open-qvf-menu");
            listActions.getElement().removeClassName("closed-qvf-menu");
            enableAllItem(true);
        } else {
            close();
        }
    }

    public static void close(Element action) {
        SpMobil.getMainPage().getHeader().actionsMenu.close();
    }

    public void close() {
        listActions.getElement().removeClassName("open-qvf-menu");
        listActions.getElement().addClassName("closed-qvf-menu");
        enableAllItem(false);
    }

    private void enableAllItem(boolean enable) {
        for (int i = 0; i < listActions.getCount(); i++) {
            ActionItem item = (ActionItem) listActions.getWidget(i);
            item.setVisible(enable);
        }
    }

    public boolean isEmpty() {
        return (listActions.getWidgetCount() == 0);
    }

    public void addAction(ActionItem action) {
        for (int i = 0; i < listActions.getWidgetCount(); i++) {
          ActionItem act = (ActionItem) listActions.getWidget(i);
          if (act.getId().equals(action.getId())) return;
        }
        listActions.add(action);
        action.setVisible(false);
        show();
    }

    public void clear() {
        listActions.clear();
        hide();
    }

    public void removeAction(String id, boolean silently) {
      for (int i = 0; i < listActions.getWidgetCount(); i++) {
        ActionItem act = (ActionItem) listActions.getWidget(i);
        if (act.getId().equals(id)) {
          listActions.remove(act);
          if (!silently) showActions(null);
          break;
        }
      }
      if (isEmpty()) {
          hide();
      }
    }

    private void show() {
        container.getElement().removeClassName("empty");
        this.actionsShortcuts.getElement().removeClassName("menu-empty");
    }

    private void hide() {
        container.getElement().addClassName("empty");
        this.actionsShortcuts.getElement().addClassName("menu-empty");
    }
}