/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class FirebaseScheduledExecutor
extends ScheduledThreadPoolExecutor {
    public FirebaseScheduledExecutor(@NonNull ThreadFactory threadFactory, @NonNull String name) {
        this(threadFactory, name, null);
    }

    public FirebaseScheduledExecutor(@NonNull ThreadFactory threadFactory, @NonNull String name, @Nullable Thread.UncaughtExceptionHandler handler) {
        super(1, FirebaseScheduledExecutor.decorateThreadFactory(threadFactory, name, handler));
        this.setRemoveOnCancelPolicy(true);
    }

    static ThreadFactory getThreadFactoryWithName(@NonNull ThreadFactory threadFactory, @NonNull String name) {
        return FirebaseScheduledExecutor.decorateThreadFactory(threadFactory, name, null);
    }

    private static ThreadFactory decorateThreadFactory(ThreadFactory threadFactory, String name, Thread.UncaughtExceptionHandler handler) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setThreadFactory(threadFactory).setNameFormat(name).setDaemon(true);
        if (handler != null) {
            builder.setUncaughtExceptionHandler(handler);
        }
        return builder.build();
    }
}

