/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.vm.impl;

import com.google.gwt.core.client.impl.WeakMapping;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.shared.impl.AbstractAutoBean;
import com.google.web.bindery.autobean.vm.Configuration;
import com.google.web.bindery.autobean.vm.impl.BeanMethod;
import com.google.web.bindery.autobean.vm.impl.BeanPropertyContext;
import com.google.web.bindery.autobean.vm.impl.GetterPropertyContext;
import com.google.web.bindery.autobean.vm.impl.MethodPropertyContext;
import com.google.web.bindery.autobean.vm.impl.ShimHandler;
import com.google.web.bindery.autobean.vm.impl.SimpleBeanHandler;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class ProxyAutoBean<T>
extends AbstractAutoBean<T> {
    private static final Map<Class<?>, Map<String, Data>> cache = new WeakHashMap();
    private final Class<T> beanType;
    private final Configuration configuration;
    private final Map<String, Data> propertyData;
    private WeakReference<T> shim;

    public static <T> T makeProxy(Class<T> intf, InvocationHandler handler, Class<?> ... extraInterfaces) {
        Class[] intfs;
        if (extraInterfaces == null) {
            intfs = new Class[]{intf};
        } else {
            intfs = new Class[extraInterfaces.length + 1];
            intfs[0] = intf;
            System.arraycopy(extraInterfaces, 0, intfs, 1, extraInterfaces.length);
        }
        return intf.cast(Proxy.newProxyInstance(intf.getClassLoader(), intfs, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Data> calculateData(Class<?> beanType) {
        Map<String, Data> toReturn;
        Map<Class<?>, Map<String, Data>> map = cache;
        synchronized (map) {
            toReturn = cache.get(beanType);
            if (toReturn == null) {
                HashMap<String, Data> getters = new HashMap<String, Data>();
                ArrayList<Method> setters = new ArrayList<Method>();
                for (Method method : beanType.getMethods()) {
                    if (BeanMethod.GET.matches(method)) {
                        String name = method.getName();
                        Type genericReturnType = TypeUtils.resolveGenerics(beanType, method.getGenericReturnType());
                        Class<?> returnType = TypeUtils.ensureBaseType(genericReturnType);
                        Data data = (Data)getters.get(name);
                        if (data != null && !data.type.isAssignableFrom(returnType)) continue;
                        PropertyType propertyType = TypeUtils.isValueType(returnType) ? PropertyType.VALUE : (Collection.class.isAssignableFrom(returnType) ? PropertyType.COLLECTION : (Map.class.isAssignableFrom(returnType) ? PropertyType.MAP : PropertyType.REFERENCE));
                        data = new Data(method, genericReturnType, returnType, propertyType);
                        getters.put(name, data);
                        continue;
                    }
                    if (!BeanMethod.SET.matches(method) && !BeanMethod.SET_BUILDER.matches(method)) continue;
                    setters.add(method);
                }
                toReturn = new HashMap<String, Data>(getters.size());
                for (Map.Entry entry : getters.entrySet()) {
                    Data data = (Data)entry.getValue();
                    toReturn.put(BeanMethod.GET.inferName(data.getter), data);
                }
                for (Method method : setters) {
                    String name = BeanMethod.SET.inferName(method);
                    Data data = toReturn.get(name);
                    if (data == null || data.setter != null || !data.getter.getReturnType().isAssignableFrom(method.getParameterTypes()[0])) continue;
                    data.setter = method;
                }
                cache.put(beanType, toReturn);
            }
        }
        return toReturn;
    }

    public ProxyAutoBean(AutoBeanFactory factory, Class<?> beanType, Configuration configuration) {
        super(factory);
        this.beanType = beanType;
        this.configuration = configuration;
        this.propertyData = ProxyAutoBean.calculateData(beanType);
    }

    public ProxyAutoBean(AutoBeanFactory factory, Class<?> beanType, Configuration configuration, T toWrap) {
        super(toWrap, factory);
        this.beanType = beanType;
        this.configuration = configuration;
        this.propertyData = ProxyAutoBean.calculateData(beanType);
    }

    @Override
    public T as() {
        Object toReturn;
        Object t = toReturn = this.shim == null ? null : (Object)this.shim.get();
        if (toReturn == null) {
            toReturn = this.createShim();
            this.shim = new WeakReference<Object>(toReturn);
        }
        return toReturn;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Class<T> getType() {
        return this.beanType;
    }

    @Override
    protected void call(String method, Object returned, Object ... parameters) {
        super.call(method, returned, parameters);
    }

    @Override
    protected void checkFrozen() {
        super.checkFrozen();
    }

    @Override
    protected void checkWrapped() {
        super.checkWrapped();
    }

    @Override
    protected T createSimplePeer() {
        return null;
    }

    @Override
    protected <V> V get(String method, V toReturn) {
        return super.get(method, toReturn);
    }

    @Override
    protected <V> V getOrReify(String propertyName) {
        return (V)super.getOrReify(propertyName);
    }

    @Override
    protected T getWrapped() {
        if (this.wrapped == null && this.isUsingSimplePeer()) {
            this.wrapped = ProxyAutoBean.makeProxy(this.beanType, new SimpleBeanHandler(this), new Class[0]);
        }
        return super.getWrapped();
    }

    @Override
    protected void set(String method, Object value) {
        super.set(method, value);
    }

    @Override
    protected void setProperty(String propertyName, Object value) {
        super.setProperty(propertyName, value);
    }

    @Override
    protected void traverseProperties(AutoBeanVisitor visitor, AbstractAutoBean.OneShotContext ctx) {
        for (Map.Entry<String, Data> entry : this.propertyData.entrySet()) {
            Object value;
            String name = entry.getKey();
            Data data = entry.getValue();
            Method getter = data.getter;
            PropertyType propertyType = data.propertyType;
            try {
                getter.setAccessible(true);
                value = getter.invoke(this.as(), new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            MethodPropertyContext x = this.isUsingSimplePeer() ? new BeanPropertyContext(this, name, data.genericType, data.type, data.elementType, data.keyType, data.valueType) : new GetterPropertyContext(this, getter, data.genericType, data.type, data.elementType, data.keyType, data.valueType);
            switch (propertyType) {
                case VALUE: {
                    if (visitor.visitValueProperty(name, value, x)) {
                        // empty if block
                    }
                    visitor.endVisitValueProperty(name, value, x);
                    break;
                }
                case COLLECTION: {
                    AutoBean<Collection<?>> temp;
                    AutoBean<Collection<?>> bean = temp = AutoBeanUtils.getAutoBean((Collection)value);
                    if (visitor.visitCollectionProperty(name, bean, x) && value != null) {
                        ((ProxyAutoBean)bean).traverse(visitor, ctx);
                    }
                    visitor.endVisitCollectionProperty(name, bean, x);
                    break;
                }
                case MAP: {
                    AutoBean<Collection<?>> temp;
                    AutoBean<Collection<?>> bean = temp = AutoBeanUtils.getAutoBean((Map)value);
                    if (visitor.visitMapProperty(name, bean, x) && value != null) {
                        ((ProxyAutoBean)bean).traverse(visitor, ctx);
                    }
                    visitor.endVisitMapProperty(name, bean, x);
                    break;
                }
                case REFERENCE: {
                    ProxyAutoBean bean = (ProxyAutoBean)AutoBeanUtils.getAutoBean(value);
                    if (visitor.visitReferenceProperty(name, bean, x) && value != null) {
                        bean.traverse(visitor, ctx);
                    }
                    visitor.endVisitReferenceProperty(name, bean, x);
                    break;
                }
            }
        }
    }

    private T createShim() {
        T toReturn = ProxyAutoBean.makeProxy(this.beanType, new ShimHandler<T>(this, this.getWrapped()), new Class[0]);
        WeakMapping.setWeak(toReturn, AutoBean.class.getName(), this);
        return toReturn;
    }

    private static class Data {
        final Class<?> elementType;
        final Type genericType;
        final Method getter;
        final Class<?> keyType;
        final PropertyType propertyType;
        Method setter;
        final Class<?> type;
        final Class<?> valueType;

        Data(Method getter, Type genericType, Class<?> type, PropertyType propertyType) {
            this.getter = getter;
            this.genericType = genericType;
            this.type = type;
            this.propertyType = propertyType;
            if (propertyType == PropertyType.COLLECTION) {
                this.elementType = TypeUtils.ensureBaseType(TypeUtils.getSingleParameterization(Collection.class, genericType, type));
                this.valueType = null;
                this.keyType = null;
            } else if (propertyType == PropertyType.MAP) {
                this.elementType = null;
                Type[] types = TypeUtils.getParameterization(Map.class, genericType, type);
                this.keyType = TypeUtils.ensureBaseType(types[0]);
                this.valueType = TypeUtils.ensureBaseType(types[1]);
            } else {
                this.valueType = null;
                this.keyType = null;
                this.elementType = null;
            }
        }
    }

    private static enum PropertyType {
        VALUE,
        REFERENCE,
        COLLECTION,
        MAP;

    }
}

