/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.client.rpc.CustomFieldSerializer;
import com.google.gwt.user.client.rpc.GwtTransient;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.ServerCustomFieldSerializer;
import com.google.gwt.user.server.rpc.impl.DequeMap;
import com.google.gwt.user.server.rpc.impl.SerializedInstanceReference;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.CRC32;

public class SerializabilityUtil {
    public static final Comparator<Field> FIELD_COMPARATOR = new Comparator<Field>(){

        @Override
        public int compare(Field f1, Field f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };
    private static final Map<Class<?>, String> classCRC32Cache = new ConcurrentHashMap();
    private static final Map<Class<?>, Field[]> classSerializableFieldsCache = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> classCustomSerializerCache = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> classServerCustomSerializerCache = new ConcurrentHashMap();
    private static final Map<Class<?>, CustomFieldSerializer<?>> CLASS_TO_SERIALIZER_INSTANCE = new ConcurrentHashMap();
    private static final String JRE_SERVER_SERIALIZER_PACKAGE = "com.google.gwt.user.server.rpc.core";
    private static final String JRE_SERIALIZER_PACKAGE = "com.google.gwt.user.client.rpc.core";
    private static final ServerCustomFieldSerializer<?> NO_SUCH_SERIALIZER = new ServerCustomFieldSerializer<Object>(){

        @Override
        public void deserializeInstance(SerializationStreamReader streamReader, Object instance) {
            throw new AssertionError((Object)"This should never be called.");
        }

        @Override
        public void deserializeInstance(ServerSerializationStreamReader streamReader, Object instance, Type[] expectedParameterTypes, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException {
            throw new SerializationException("This should never be called.");
        }

        @Override
        public void serializeInstance(SerializationStreamWriter streamWriter, Object instance) {
            throw new AssertionError((Object)"This should never be called.");
        }
    };
    private static final Map<String, String> SERIALIZED_PRIMITIVE_TYPE_NAMES = new HashMap<String, String>();
    private static final Set<Class<?>> TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES = new HashSet();

    @Deprecated
    public static Field[] applyFieldSerializationPolicy(Class<?> clazz) {
        return SerializabilityUtil.applyFieldSerializationPolicy(clazz, false);
    }

    public static Field[] applyFieldSerializationPolicy(Class<?> clazz, SerializationPolicy policy) {
        return SerializabilityUtil.applyFieldSerializationPolicy(clazz, policy.shouldSerializeFinalFields());
    }

    private static Field[] applyFieldSerializationPolicy(Class<?> clazz, boolean includeFinalFields) {
        Field[] serializableFields = classSerializableFieldsCache.get(clazz);
        if (serializableFields == null) {
            Field[] fields;
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!SerializabilityUtil.fieldQualifiesForSerialization(field, includeFinalFields)) continue;
                fieldList.add(field);
            }
            serializableFields = fieldList.toArray(new Field[fieldList.size()]);
            Arrays.sort(serializableFields, 0, serializableFields.length, FIELD_COMPARATOR);
            classSerializableFieldsCache.put(clazz, serializableFields);
        }
        return serializableFields;
    }

    public static SerializedInstanceReference decodeSerializedInstanceReference(String encodedSerializedInstanceReference) {
        final String[] components = encodedSerializedInstanceReference.split("/");
        return new SerializedInstanceReference(){

            @Override
            public String getName() {
                return components.length > 0 ? components[0] : "";
            }

            @Override
            public String getSignature() {
                return components.length > 1 ? components[1] : "";
            }
        };
    }

    public static String encodeSerializedInstanceReference(Class<?> instanceType, SerializationPolicy policy) {
        return instanceType.getName() + "/" + SerializabilityUtil.getSerializationSignature(instanceType, policy);
    }

    public static Type findActualType(Type unresolved, DequeMap<TypeVariable<?>, Type> resolvedTypes) {
        if (!(unresolved instanceof TypeVariable)) {
            return unresolved;
        }
        TypeVariable var = (TypeVariable)unresolved;
        Type target = resolvedTypes.get(var);
        if (target == null || target == var) {
            return var;
        }
        if (!(target instanceof TypeVariable)) {
            return target;
        }
        HashSet<TypeVariable> seen = new HashSet<TypeVariable>();
        seen.add(var);
        var = (TypeVariable)target;
        seen.add(var);
        do {
            if ((target = resolvedTypes.get(var)) == null || target == var) {
                return var;
            }
            if (target instanceof TypeVariable) continue;
            return target;
        } while (seen.add(var = (TypeVariable)target));
        return var;
    }

    public static Type[] findExpectedParameterTypes(Class<?> instanceClass, Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes) {
        TypeVariable<Class<?>>[] instanceTypes = instanceClass.getTypeParameters();
        Type[] expectedParameterTypes = (Type[])Arrays.copyOf(instanceTypes, instanceTypes.length, Type[].class);
        if (expectedType == null) {
            if (resolvedTypes != null) {
                SerializabilityUtil.findInstanceParameters(instanceClass, resolvedTypes, expectedParameterTypes);
            }
        } else {
            HashSet expectedInstanceClasses;
            Type actualType = SerializabilityUtil.findActualType(expectedType, resolvedTypes);
            if (!SerializabilityUtil.findExpectedInstanceClass(instanceClass, actualType, resolvedTypes, expectedInstanceClasses = new HashSet(), expectedParameterTypes)) {
                return null;
            }
            if (resolvedTypes != null) {
                for (Class clazz : expectedInstanceClasses) {
                    SerializabilityUtil.findInstanceParameters(clazz, resolvedTypes, expectedParameterTypes);
                }
            }
        }
        return expectedParameterTypes;
    }

    public static Class<?> getClassFromType(Type type, DequeMap<TypeVariable<?>, Type> resolvedTypes) {
        Type actualType = SerializabilityUtil.findActualType(type, resolvedTypes);
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (type instanceof ParameterizedType) {
            return SerializabilityUtil.getClassFromType(((ParameterizedType)actualType).getRawType(), resolvedTypes);
        }
        return null;
    }

    public static String getSerializationSignature(Class<?> instanceType, SerializationPolicy policy) {
        String result = classCRC32Cache.get(instanceType);
        if (result == null) {
            CRC32 crc = new CRC32();
            try {
                SerializabilityUtil.generateSerializationSignature(instanceType, crc, policy);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Could not compute the serialization signature", e);
            }
            result = Long.toString(crc.getValue());
            classCRC32Cache.put(instanceType, result);
        }
        return result;
    }

    public static String getSerializedTypeName(Class<?> instanceType) {
        if (instanceType.isPrimitive()) {
            return SERIALIZED_PRIMITIVE_TYPE_NAMES.get(instanceType.getName());
        }
        return instanceType.getName();
    }

    public static Class<?> hasCustomFieldSerializer(Class<?> instanceType) {
        assert (instanceType != null);
        if (instanceType.isArray()) {
            return null;
        }
        Class<?> result = classCustomSerializerCache.get(instanceType);
        if (result == null) {
            result = SerializabilityUtil.computeHasCustomFieldSerializer(instanceType, false);
            if (result == null) {
                result = instanceType;
            }
            classCustomSerializerCache.put(instanceType, result);
        }
        return result == instanceType ? null : result;
    }

    public static Class<?> hasServerCustomFieldSerializer(Class<?> instanceType) {
        assert (instanceType != null);
        if (instanceType.isArray()) {
            return null;
        }
        Class<?> result = classServerCustomSerializerCache.get(instanceType);
        if (result == null) {
            result = SerializabilityUtil.computeHasCustomFieldSerializer(instanceType, true);
            if (result == null) {
                result = instanceType;
            }
            classServerCustomSerializerCache.put(instanceType, result);
        }
        return result == instanceType ? null : result;
    }

    public static void releaseTypes(Type methodType, DequeMap<TypeVariable<?>, Type> resolvedTypes) {
        SerializabilityUtil.resolveTypesWorker(methodType, resolvedTypes, false);
    }

    public static void resolveTypes(Type methodType, DequeMap<TypeVariable<?>, Type> resolvedTypes) {
        SerializabilityUtil.resolveTypesWorker(methodType, resolvedTypes, true);
    }

    private static boolean hasGwtTransientAnnotation(Field field) {
        for (Annotation a : field.getAnnotations()) {
            if (!a.annotationType().getSimpleName().equals(GwtTransient.class.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    static boolean isNotStaticOrTransient(Field field) {
        int fieldModifiers = field.getModifiers();
        return !Modifier.isStatic(fieldModifiers) && !Modifier.isTransient(fieldModifiers) && !SerializabilityUtil.hasGwtTransientAnnotation(field);
    }

    static boolean isNotFinal(Field field) {
        return !Modifier.isFinal(field.getModifiers());
    }

    static CustomFieldSerializer<?> loadCustomFieldSerializer(Class<?> customSerializerClass) throws SerializationException {
        CustomFieldSerializer customFieldSerializer = CLASS_TO_SERIALIZER_INSTANCE.get(customSerializerClass);
        if (customFieldSerializer == null) {
            if (CustomFieldSerializer.class.isAssignableFrom(customSerializerClass)) {
                try {
                    customFieldSerializer = (CustomFieldSerializer)customSerializerClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new SerializationException(e);
                }
                catch (IllegalAccessException e) {
                    throw new SerializationException(e);
                }
            } else {
                customFieldSerializer = NO_SUCH_SERIALIZER;
            }
            CLASS_TO_SERIALIZER_INSTANCE.put(customSerializerClass, customFieldSerializer);
        }
        if (customFieldSerializer == NO_SUCH_SERIALIZER) {
            return null;
        }
        return customFieldSerializer;
    }

    private static Class<?> computeHasCustomFieldSerializer(Class<?> instanceType, Boolean typeChecked) {
        String simpleSerializerName;
        Class<?> customSerializer;
        ClassLoader classLoader;
        assert (instanceType != null);
        String qualifiedTypeName = instanceType.getName();
        ClassLoader classLoader2 = classLoader = GWT.isClient() ? SerializabilityUtil.class.getClassLoader() : Thread.currentThread().getContextClassLoader();
        if (typeChecked.booleanValue()) {
            String serverSerializerName = qualifiedTypeName + "_ServerCustomFieldSerializer";
            Class<?> serverCustomSerializer = SerializabilityUtil.getCustomFieldSerializer(classLoader, serverSerializerName = serverSerializerName.replaceFirst("client", "server"));
            if (serverCustomSerializer != null) {
                return serverCustomSerializer;
            }
            serverCustomSerializer = SerializabilityUtil.getCustomFieldSerializer(classLoader, "com.google.gwt.user.server.rpc.core." + serverSerializerName);
            if (serverCustomSerializer != null) {
                return serverCustomSerializer;
            }
        }
        if ((customSerializer = SerializabilityUtil.getCustomFieldSerializer(classLoader, simpleSerializerName = qualifiedTypeName + "_CustomFieldSerializer")) != null) {
            return customSerializer;
        }
        customSerializer = SerializabilityUtil.getCustomFieldSerializer(classLoader, "com.google.gwt.user.client.rpc.core." + simpleSerializerName);
        if (customSerializer != null) {
            return customSerializer;
        }
        return null;
    }

    private static boolean excludeImplementationFromSerializationSignature(Class<?> instanceType) {
        return TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.contains(instanceType);
    }

    private static boolean fieldQualifiesForSerialization(Field field, boolean includeFinal) {
        if (Throwable.class == field.getDeclaringClass()) {
            if ("detailMessage".equals(field.getName())) {
                assert (SerializabilityUtil.isNotStaticOrTransient(field));
                return true;
            }
            return false;
        }
        return SerializabilityUtil.isNotStaticOrTransient(field) && (includeFinal || SerializabilityUtil.isNotFinal(field));
    }

    private static boolean findExpectedInstanceClass(Class<?> instanceClass, Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes, Set<Class<?>> expectedInstanceClasses, Type[] expectedParameterTypes) {
        Type[] interfaces;
        if (expectedType instanceof TypeVariable) {
            Type[] typeVariableBounds;
            for (Type boundType : typeVariableBounds = ((TypeVariable)expectedType).getBounds()) {
                if (SerializabilityUtil.findExpectedInstanceClass(instanceClass, boundType, resolvedTypes, expectedInstanceClasses, expectedParameterTypes)) continue;
                return false;
            }
            return true;
        }
        if (expectedType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)expectedType;
            if (paramType.getRawType() == instanceClass) {
                expectedInstanceClasses.add(instanceClass);
                return true;
            }
        } else if (expectedType instanceof GenericArrayType) {
            if (instanceClass.isArray()) {
                expectedInstanceClasses.add(instanceClass);
                return true;
            }
        } else {
            if (expectedType instanceof WildcardType) {
                Type[] upperBounds;
                Type[] lowerBounds;
                WildcardType wildcardType = (WildcardType)expectedType;
                for (Type type : lowerBounds = wildcardType.getLowerBounds()) {
                    Class<?> boundClass;
                    for (boundClass = SerializabilityUtil.getClassFromType(type, resolvedTypes); boundClass != null; boundClass = boundClass.getSuperclass()) {
                        if (instanceClass != boundClass) continue;
                        expectedInstanceClasses.add(boundClass);
                        break;
                    }
                    if (boundClass != null) continue;
                    return false;
                }
                for (Type type : upperBounds = wildcardType.getUpperBounds()) {
                    if (SerializabilityUtil.findExpectedInstanceClass(instanceClass, type, resolvedTypes, expectedInstanceClasses, expectedParameterTypes)) continue;
                    return false;
                }
                return true;
            }
            if (((Class)expectedType).getComponentType() != null) {
                if (((Class)expectedType).isAssignableFrom(instanceClass)) {
                    expectedInstanceClasses.add(instanceClass);
                    return true;
                }
                return false;
            }
            if ((Class)expectedType == instanceClass) {
                expectedInstanceClasses.add(instanceClass);
                return true;
            }
        }
        if (instanceClass.getGenericSuperclass() != null) {
            Type[] localTypes = (Type[])expectedParameterTypes.clone();
            if (SerializabilityUtil.findExpectedInstanceClassFromSuper(instanceClass.getGenericSuperclass(), expectedType, resolvedTypes, expectedInstanceClasses, localTypes)) {
                for (int i = 0; i < expectedParameterTypes.length; ++i) {
                    expectedParameterTypes[i] = localTypes[i];
                }
                return true;
            }
        }
        for (Type interfaceType : interfaces = instanceClass.getGenericInterfaces()) {
            Type[] localTypes = (Type[])expectedParameterTypes.clone();
            if (!SerializabilityUtil.findExpectedInstanceClassFromSuper(interfaceType, expectedType, resolvedTypes, expectedInstanceClasses, localTypes)) continue;
            for (int i = 0; i < expectedParameterTypes.length; ++i) {
                expectedParameterTypes[i] = localTypes[i];
            }
            return true;
        }
        return false;
    }

    private static boolean findExpectedInstanceClassFromSuper(Type superType, Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes, Set<Class<?>> expectedInstanceClasses, Type[] expectedParameterTypes) {
        if (superType instanceof GenericArrayType) {
            return false;
        }
        if (superType instanceof Class) {
            return SerializabilityUtil.findExpectedInstanceClass((Class)superType, expectedType, resolvedTypes, expectedInstanceClasses, expectedParameterTypes);
        }
        if (superType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)superType;
            Type rawType = paramType.getRawType();
            if (rawType instanceof Class) {
                Class rawClass = (Class)rawType;
                TypeVariable<Class<T>>[] classGenericTypes = rawClass.getTypeParameters();
                Type[] actualTypes = paramType.getActualTypeArguments();
                for (int i = 0; i < actualTypes.length; ++i) {
                    for (int j = 0; j < expectedParameterTypes.length; ++j) {
                        if (actualTypes[i] != expectedParameterTypes[j]) continue;
                        expectedParameterTypes[j] = classGenericTypes[i];
                    }
                }
                return SerializabilityUtil.findExpectedInstanceClass(rawClass, expectedType, resolvedTypes, expectedInstanceClasses, expectedParameterTypes);
            }
        } else if (superType instanceof WildcardType) {
            Type[] upperBounds;
            WildcardType wildcardType = (WildcardType)superType;
            for (Type boundType : upperBounds = wildcardType.getUpperBounds()) {
                if (!SerializabilityUtil.findExpectedInstanceClassFromSuper(boundType, expectedType, resolvedTypes, expectedInstanceClasses, expectedParameterTypes)) continue;
                return true;
            }
        }
        return false;
    }

    private static Type findInstanceParameter(Type foundParameter, Type instanceType, DequeMap<TypeVariable<?>, Type> resolvedTypes) {
        block8: {
            block7: {
                if (instanceType instanceof GenericArrayType) {
                    return SerializabilityUtil.findInstanceParameter(foundParameter, ((GenericArrayType)instanceType).getGenericComponentType(), resolvedTypes);
                }
                if (!(instanceType instanceof ParameterizedType)) break block7;
                ParameterizedType paramType = (ParameterizedType)instanceType;
                Type rawType = paramType.getRawType();
                if (!(rawType instanceof Class)) break block8;
                Class rawClass = (Class)rawType;
                TypeVariable<Class<T>>[] classGenericTypes = rawClass.getTypeParameters();
                Type[] actualTypes = paramType.getActualTypeArguments();
                for (int i = 0; i < actualTypes.length; ++i) {
                    Type[] rawInterfaces;
                    Type superParameter;
                    if (actualTypes[i] != foundParameter) continue;
                    Type capturedType = SerializabilityUtil.findActualType(classGenericTypes[i], resolvedTypes);
                    if (capturedType != classGenericTypes[i]) {
                        return capturedType;
                    }
                    if (rawClass.getGenericSuperclass() != null && !((superParameter = SerializabilityUtil.findInstanceParameter(classGenericTypes[i], rawClass.getGenericSuperclass(), resolvedTypes)) instanceof TypeVariable)) {
                        return superParameter;
                    }
                    for (Type interfaceType : rawInterfaces = rawClass.getGenericInterfaces()) {
                        Type interfaceParameter = SerializabilityUtil.findInstanceParameter(classGenericTypes[i], interfaceType, resolvedTypes);
                        if (interfaceParameter instanceof TypeVariable) continue;
                        return interfaceParameter;
                    }
                }
                break block8;
            }
            if (instanceType instanceof WildcardType) {
                Type[] upperBounds;
                WildcardType wildcardType = (WildcardType)instanceType;
                for (Type boundType : upperBounds = wildcardType.getUpperBounds()) {
                    Type wildcardParameter = SerializabilityUtil.findInstanceParameter(foundParameter, boundType, resolvedTypes);
                    if (wildcardParameter instanceof TypeVariable) continue;
                    return wildcardParameter;
                }
            }
        }
        return foundParameter;
    }

    private static void findInstanceParameters(Class<?> instanceClass, DequeMap<TypeVariable<?>, Type> resolvedTypes, Type[] expectedParameterTypes) {
        TypeVariable<Class<?>>[] instanceTypes = instanceClass.getTypeParameters();
        block0: for (int i = 0; i < expectedParameterTypes.length; ++i) {
            Type[] interfaceTypes;
            Type superParameter;
            if (!(expectedParameterTypes[i] instanceof TypeVariable)) continue;
            boolean haveMatch = false;
            for (int j = 0; !haveMatch && j < instanceTypes.length; ++j) {
                Type capturedType;
                if (expectedParameterTypes[i] != instanceTypes[j] || (capturedType = SerializabilityUtil.findActualType(instanceTypes[j], resolvedTypes)) instanceof TypeVariable) continue;
                expectedParameterTypes[i] = capturedType;
                haveMatch = true;
            }
            if (haveMatch) continue;
            if (instanceClass.getGenericSuperclass() != null && !((superParameter = SerializabilityUtil.findInstanceParameter(expectedParameterTypes[i], instanceClass.getGenericSuperclass(), resolvedTypes)) instanceof TypeVariable)) {
                expectedParameterTypes[i] = superParameter;
                continue;
            }
            for (Type interfaceType : interfaceTypes = instanceClass.getGenericInterfaces()) {
                Type interfaceParameter = SerializabilityUtil.findInstanceParameter(expectedParameterTypes[i], interfaceType, resolvedTypes);
                if (interfaceParameter instanceof TypeVariable) continue;
                expectedParameterTypes[i] = interfaceParameter;
                continue block0;
            }
        }
    }

    private static void generateSerializationSignature(Class<?> instanceType, CRC32 crc, SerializationPolicy policy) throws UnsupportedEncodingException {
        crc.update(SerializabilityUtil.getSerializedTypeName(instanceType).getBytes(StandardCharsets.UTF_8));
        if (SerializabilityUtil.excludeImplementationFromSerializationSignature(instanceType)) {
            return;
        }
        Class<?> customSerializer = SerializabilityUtil.hasCustomFieldSerializer(instanceType);
        if (customSerializer != null) {
            SerializabilityUtil.generateSerializationSignature(customSerializer, crc, policy);
        } else if (instanceType.isArray()) {
            SerializabilityUtil.generateSerializationSignature(instanceType.getComponentType(), crc, policy);
        } else if (Enum.class.isAssignableFrom(instanceType) && !Enum.class.equals(instanceType)) {
            Enum[] constants;
            if (!instanceType.isEnum()) {
                instanceType = instanceType.getSuperclass();
            }
            for (Enum constant : constants = instanceType.asSubclass(Enum.class).getEnumConstants()) {
                crc.update(constant.name().getBytes(StandardCharsets.UTF_8));
            }
        } else if (!instanceType.isPrimitive()) {
            Field[] fields = SerializabilityUtil.applyFieldSerializationPolicy(instanceType, policy);
            Set<String> clientFieldNames = policy.getClientFieldNamesForEnhancedClass(instanceType);
            for (Field field : fields) {
                assert (field != null);
                if (clientFieldNames != null && !clientFieldNames.contains(field.getName())) continue;
                crc.update(field.getName().getBytes(StandardCharsets.UTF_8));
                crc.update(SerializabilityUtil.getSerializedTypeName(field.getType()).getBytes(StandardCharsets.UTF_8));
            }
            Class<?> superClass = instanceType.getSuperclass();
            if (superClass != null) {
                SerializabilityUtil.generateSerializationSignature(superClass, crc, policy);
            }
        }
    }

    private static Class<?> getCustomFieldSerializer(ClassLoader classLoader, String qualifiedSerialzierName) {
        try {
            Class<?> customSerializerClass = Class.forName(qualifiedSerialzierName, false, classLoader);
            return customSerializerClass;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static void resolveTypesWorker(Type methodType, DequeMap<TypeVariable<?>, Type> resolvedTypes, boolean addTypes) {
        block17: {
            block18: {
                Type[] interfaceTypes;
                block16: {
                    if (!(methodType instanceof GenericArrayType)) break block16;
                    SerializabilityUtil.resolveTypesWorker(((GenericArrayType)methodType).getGenericComponentType(), resolvedTypes, addTypes);
                    break block17;
                }
                if (!(methodType instanceof ParameterizedType)) break block18;
                ParameterizedType paramType = (ParameterizedType)methodType;
                Type rawType = paramType.getRawType();
                if (!(rawType instanceof Class)) break block17;
                Class rawClass = (Class)paramType.getRawType();
                TypeVariable<Class<T>>[] classGenericTypes = rawClass.getTypeParameters();
                Type[] actualTypes = paramType.getActualTypeArguments();
                for (int i = 0; i < actualTypes.length; ++i) {
                    TypeVariable variableType = classGenericTypes[i];
                    if (addTypes) {
                        resolvedTypes.add(variableType, actualTypes[i]);
                        continue;
                    }
                    resolvedTypes.remove(variableType);
                }
                Class superClass = rawClass.getSuperclass();
                if (superClass != null) {
                    Type superGenericType = rawClass.getGenericSuperclass();
                    SerializabilityUtil.resolveTypesWorker(superGenericType, resolvedTypes, addTypes);
                }
                for (Type interfaceType : interfaceTypes = rawClass.getGenericInterfaces()) {
                    SerializabilityUtil.resolveTypesWorker(interfaceType, resolvedTypes, addTypes);
                }
                break block17;
            }
            if (methodType instanceof WildcardType) {
                Type[] upperBounds;
                Type[] lowerBounds;
                WildcardType wildcardType = (WildcardType)methodType;
                for (Type type : lowerBounds = wildcardType.getLowerBounds()) {
                    SerializabilityUtil.resolveTypesWorker(type, resolvedTypes, addTypes);
                }
                for (Type type : upperBounds = wildcardType.getUpperBounds()) {
                    SerializabilityUtil.resolveTypesWorker(type, resolvedTypes, addTypes);
                }
            } else if (methodType instanceof TypeVariable) {
                Type[] bounds;
                for (Type type : bounds = ((TypeVariable)methodType).getBounds()) {
                    SerializabilityUtil.resolveTypesWorker(type, resolvedTypes, addTypes);
                }
            } else if (methodType instanceof Class) {
                Type[] interfaceTypes;
                TypeVariable<Class<T>>[] classParams;
                Class classType = (Class)methodType;
                for (TypeVariable classParamType : classParams = classType.getTypeParameters()) {
                    if (addTypes) {
                        resolvedTypes.add(classParamType, classParamType);
                        continue;
                    }
                    resolvedTypes.remove(classParamType);
                }
                Type superGenericType = classType.getGenericSuperclass();
                if (superGenericType != null) {
                    SerializabilityUtil.resolveTypesWorker(superGenericType, resolvedTypes, addTypes);
                }
                for (Type interfaceType : interfaceTypes = classType.getGenericInterfaces()) {
                    SerializabilityUtil.resolveTypesWorker(interfaceType, resolvedTypes, addTypes);
                }
            }
        }
    }

    static {
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Boolean.TYPE.getName(), "Z");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Byte.TYPE.getName(), "B");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Character.TYPE.getName(), "C");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Double.TYPE.getName(), "D");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Float.TYPE.getName(), "F");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Integer.TYPE.getName(), "I");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Long.TYPE.getName(), "J");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Short.TYPE.getName(), "S");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Boolean.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Byte.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Character.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Double.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Exception.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Float.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Integer.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Long.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Object.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Short.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(String.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Throwable.class);
        try {
            Class<?> clazz = Class.forName("junit.framework.AssertionFailedError");
            TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

