/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.dom.builder.shared.ElementBuilderBase;
import com.google.gwt.dom.builder.shared.HtmlBuilderFactory;
import com.google.gwt.dom.builder.shared.HtmlTableSectionBuilder;
import com.google.gwt.dom.builder.shared.TableRowBuilder;
import com.google.gwt.dom.builder.shared.TableSectionBuilder;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTableBuilder;
import com.google.gwt.user.cellview.client.Column;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCellTableBuilder<T>
implements CellTableBuilder<T> {
    private static final String CELL_ATTRIBUTE = "__gwt_cell";
    private static final String ROW_ATTRIBUTE = "__gwt_row";
    private static final String SUBROW_ATTRIBUTE = "__gwt_subrow";
    protected final AbstractCellTable<T> cellTable;
    private final Map<String, HasCell<T, ?>> idToCellMap = new HashMap();
    private final Map<HasCell<T, ?>, String> cellToIdMap = new HashMap();
    private HtmlTableSectionBuilder tbody;
    private int rowIndex;
    private int subrowIndex;
    private Object rowValueKey;

    public AbstractCellTableBuilder(AbstractCellTable<T> cellTable) {
        this.cellTable = cellTable;
    }

    @Override
    public final void buildRow(T rowValue, int absRowIndex) {
        this.setRowInfo(absRowIndex, rowValue);
        this.buildRowImpl(rowValue, absRowIndex);
    }

    public final Cell.Context createContext(int column) {
        return new Cell.Context(this.rowIndex, column, this.rowValueKey, this.subrowIndex);
    }

    @Override
    public final TableSectionBuilder finish() {
        while (this.tbody.getDepth() > 0) {
            this.tbody.endTBody();
        }
        return this.tbody;
    }

    @Override
    public final HasCell<T, ?> getColumn(Cell.Context context, T rowValue, Element elem) {
        return this.getColumn(elem);
    }

    @Override
    public final Collection<HasCell<T, ?>> getColumns() {
        return this.idToCellMap.values();
    }

    @Override
    public final int getRowValueIndex(TableRowElement row) {
        try {
            return Integer.parseInt(row.getAttribute(ROW_ATTRIBUTE));
        }
        catch (NumberFormatException e) {
            return row.getSectionRowIndex() + this.cellTable.getPageStart();
        }
    }

    @Override
    public final int getSubrowValueIndex(TableRowElement row) {
        try {
            return Integer.parseInt(row.getAttribute(SUBROW_ATTRIBUTE));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public final boolean isColumn(Element elem) {
        return this.getCellId(elem) != null;
    }

    public final <C> void renderCell(ElementBuilderBase<?> builder, Cell.Context context, HasCell<T, C> column, T rowValue) {
        String cellId = this.cellToIdMap.get(column);
        if (cellId == null) {
            cellId = "cell-" + Document.get().createUniqueId();
            this.idToCellMap.put(cellId, column);
            this.cellToIdMap.put(column, cellId);
        }
        builder.attribute(CELL_ATTRIBUTE, cellId);
        SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
        if (column instanceof Column) {
            Column theColumn = (Column)column;
            theColumn.render(context, rowValue, cellBuilder);
        } else {
            column.getCell().render(context, column.getValue(rowValue), cellBuilder);
        }
        builder.html(cellBuilder.toSafeHtml());
    }

    @Override
    public final void start(boolean isRebuildingAllRows) {
        this.tbody = HtmlBuilderFactory.get().createTBodyBuilder();
        if (isRebuildingAllRows) {
            this.cellToIdMap.clear();
            this.idToCellMap.clear();
        }
    }

    public final TableRowBuilder startRow() {
        return this.startRow(null);
    }

    public final TableRowBuilder startRow(T rowValue) {
        while (this.tbody.getDepth() > 1) {
            this.tbody.end();
        }
        if (this.tbody.getDepth() < 1) {
            throw new IllegalStateException("Cannot start a row.  Did you call TableRowBuilder.end() too many times?");
        }
        TableRowBuilder row = this.tbody.startTR();
        row.attribute(ROW_ATTRIBUTE, this.rowIndex);
        row.attribute(SUBROW_ATTRIBUTE, this.subrowIndex);
        this.addRowAttributes(row, rowValue);
        ++this.subrowIndex;
        return row;
    }

    protected void addRowAttributes(TableRowBuilder row) {
    }

    protected void addRowAttributes(TableRowBuilder row, T rowValue) {
        this.addRowAttributes(row);
    }

    protected abstract void buildRowImpl(T var1, int var2);

    private String getCellId(Element elem) {
        if (elem == null) {
            return null;
        }
        String cellId = elem.getAttribute(CELL_ATTRIBUTE);
        return cellId == null || cellId.length() == 0 ? null : cellId;
    }

    private HasCell<T, ?> getColumn(Element elem) {
        String cellId = this.getCellId(elem);
        return cellId == null ? null : this.idToCellMap.get(cellId);
    }

    private void setRowInfo(int rowIndex, T rowValue) {
        this.rowIndex = rowIndex;
        this.rowValueKey = this.cellTable.getValueKey(rowValue);
        this.subrowIndex = 0;
    }
}

