/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.server.ArrayBufferViewImpl;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Uint8Array;

public class Uint8ArrayImpl
extends ArrayBufferViewImpl
implements Uint8Array {
    public Uint8ArrayImpl(ArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length);
    }

    @Override
    public short get(int index) {
        short val = this.arrayBuf.getInt8(this.checkRange(index, 1));
        if (val < 0) {
            val = (short)(val + 256);
        }
        return val;
    }

    @Override
    public int length() {
        return this.byteLength();
    }

    @Override
    public void set(int index, int value) {
        this.arrayBuf.setInt8(this.checkRange(index, 1), (byte)(value & 0xFF));
    }

    @Override
    public void set(int[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(int[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array[i]);
        }
    }

    @Override
    public void set(short[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(short[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, (int)array[i]);
        }
    }

    @Override
    public void set(Uint8Array array) {
        this.set(array, 0);
    }

    @Override
    public void set(Uint8Array array, int offset) {
        int len = array.length();
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, (int)array.get(i));
        }
    }

    @Override
    public Uint8Array subarray(int begin) {
        int count = (this.byteLength() - this.byteOffset()) / 1;
        return this.subarray(begin, count);
    }

    @Override
    public Uint8Array subarray(int begin, int end) {
        int count = (this.byteLength() - this.byteOffset()) / 1;
        if (begin < 0) {
            if ((begin += count) < 0) {
                begin = 0;
            }
        } else if (begin > count) {
            begin = count;
        }
        if (end < 0) {
            if ((end += count) < 0) {
                end = 0;
            }
        } else if (end > count) {
            end = count;
        }
        if (end < begin) {
            end = begin;
        }
        return new Uint8ArrayImpl(this.arrayBuf, begin * 1, end * 1);
    }
}

