/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.base.Preconditions;
import java.util.Set;

@BetaApi(value="The surface for batching is not stable yet and may change in the future.")
public final class BatchingCallSettings<ElementT, ElementResultT, RequestT, ResponseT>
extends UnaryCallSettings<RequestT, ResponseT> {
    private final BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor;
    private final BatchingSettings batchingSettings;

    @InternalApi(value="For google-cloud-java client use only")
    public BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> getBatchingDescriptor() {
        return this.batchingDescriptor;
    }

    public BatchingSettings getBatchingSettings() {
        return this.batchingSettings;
    }

    private BatchingCallSettings(Builder<ElementT, ElementResultT, RequestT, ResponseT> builder) {
        super(builder);
        Preconditions.checkState((((Builder)builder).batchingSettings != null ? 1 : 0) != 0, (Object)"batching settings cannot be null");
        this.batchingDescriptor = ((Builder)builder).batchingDescriptor;
        this.batchingSettings = ((Builder)builder).batchingSettings;
    }

    @InternalApi(value="For google-cloud-java client use only")
    public static <ElementT, ElementResultT, RequestT, ResponseT> Builder<ElementT, ElementResultT, RequestT, ResponseT> newBuilder(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor) {
        return new Builder(batchingDescriptor);
    }

    public final Builder<ElementT, ElementResultT, RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<ElementT, ElementResultT, RequestT, ResponseT>
    extends UnaryCallSettings.Builder<RequestT, ResponseT> {
        private BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor;
        private BatchingSettings batchingSettings;

        private Builder(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor) {
            this.batchingDescriptor = (BatchingDescriptor)Preconditions.checkNotNull(batchingDescriptor, (Object)"batching descriptor cannot be null");
        }

        private Builder(BatchingCallSettings<ElementT, ElementResultT, RequestT, ResponseT> settings) {
            super(settings);
            this.batchingDescriptor = ((BatchingCallSettings)settings).batchingDescriptor;
            this.batchingSettings = ((BatchingCallSettings)settings).batchingSettings;
        }

        public Builder<ElementT, ElementResultT, RequestT, ResponseT> setBatchingSettings(BatchingSettings batchingSettings) {
            this.batchingSettings = batchingSettings;
            return this;
        }

        public BatchingSettings getBatchingSettings() {
            return this.batchingSettings;
        }

        public Builder<ElementT, ElementResultT, RequestT, ResponseT> setRetryableCodes(StatusCode.Code ... codes) {
            super.setRetryableCodes(codes);
            return this;
        }

        public Builder<ElementT, ElementResultT, RequestT, ResponseT> setRetryableCodes(Set<StatusCode.Code> retryableCodes) {
            super.setRetryableCodes(retryableCodes);
            return this;
        }

        public Builder<ElementT, ElementResultT, RequestT, ResponseT> setRetrySettings(RetrySettings retrySettings) {
            super.setRetrySettings(retrySettings);
            return this;
        }

        public BatchingCallSettings<ElementT, ElementResultT, RequestT, ResponseT> build() {
            return new BatchingCallSettings(this);
        }
    }
}

