/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.HeadElement;
import com.google.gwt.dom.client.StyleElement;

public class StyleInjector {
    private static final JsArrayString toInject = (JsArrayString)JavaScriptObject.createArray().cast();
    private static final JsArrayString toInjectAtEnd = (JsArrayString)JavaScriptObject.createArray().cast();
    private static final JsArrayString toInjectAtStart = (JsArrayString)JavaScriptObject.createArray().cast();
    private static Scheduler.ScheduledCommand flusher = new Scheduler.ScheduledCommand(){

        @Override
        public void execute() {
            if (needsInjection) {
                StyleInjector.flush(null);
            }
        }
    };
    private static boolean needsInjection = false;

    public static void flush() {
        StyleInjector.inject(true);
    }

    public static void inject(String css) {
        StyleInjector.inject(css, false);
    }

    public static void inject(String css, boolean immediate) {
        toInject.push(css);
        StyleInjector.inject(immediate);
    }

    public static void injectAtEnd(String css) {
        StyleInjector.injectAtEnd(css, false);
    }

    public static void injectAtEnd(String css, boolean immediate) {
        toInjectAtEnd.push(css);
        StyleInjector.inject(immediate);
    }

    public static void injectAtStart(String css) {
        StyleInjector.injectAtStart(css, false);
    }

    public static void injectAtStart(String css, boolean immediate) {
        toInjectAtStart.unshift(css);
        StyleInjector.inject(immediate);
    }

    public static StyleElement injectStylesheet(String contents) {
        toInject.push(contents);
        return StyleInjector.flush(toInject);
    }

    public static StyleElement injectStylesheetAtEnd(String contents) {
        toInjectAtEnd.push(contents);
        return StyleInjector.flush(toInjectAtEnd);
    }

    public static StyleElement injectStylesheetAtStart(String contents) {
        toInjectAtStart.unshift(contents);
        return StyleInjector.flush(toInjectAtStart);
    }

    public static void setContents(StyleElement style, String contents) {
        StyleInjectorImpl.IMPL.setContents(style, contents);
    }

    private static StyleElement flush(JavaScriptObject which) {
        StyleElement maybeReturn;
        String css;
        StyleElement toReturn = null;
        if (toInjectAtStart.length() != 0) {
            css = toInjectAtStart.join("");
            maybeReturn = StyleInjectorImpl.IMPL.injectStyleSheetAtStart(css);
            if (toInjectAtStart == which) {
                toReturn = maybeReturn;
            }
            toInjectAtStart.setLength(0);
        }
        if (toInject.length() != 0) {
            css = toInject.join("");
            maybeReturn = StyleInjectorImpl.IMPL.injectStyleSheet(css);
            if (toInject == which) {
                toReturn = maybeReturn;
            }
            toInject.setLength(0);
        }
        if (toInjectAtEnd.length() != 0) {
            css = toInjectAtEnd.join("");
            maybeReturn = StyleInjectorImpl.IMPL.injectStyleSheetAtEnd(css);
            if (toInjectAtEnd == which) {
                toReturn = maybeReturn;
            }
            toInjectAtEnd.setLength(0);
        }
        needsInjection = false;
        return toReturn;
    }

    private static void inject(boolean immediate) {
        if (immediate) {
            StyleInjector.flush(null);
        } else {
            StyleInjector.schedule();
        }
    }

    private static void schedule() {
        if (!needsInjection) {
            needsInjection = true;
            Scheduler.get().scheduleFinally(flusher);
        }
    }

    private StyleInjector() {
    }

    @Deprecated
    public static class StyleInjectorImpl {
        private static final StyleInjectorImpl IMPL = (StyleInjectorImpl)GWT.create(StyleInjectorImpl.class);
        private HeadElement head;

        public StyleElement injectStyleSheet(String contents) {
            StyleElement style = this.createElement(contents);
            this.getHead().appendChild(style);
            return style;
        }

        public StyleElement injectStyleSheetAtEnd(String contents) {
            return this.injectStyleSheet(contents);
        }

        public StyleElement injectStyleSheetAtStart(String contents) {
            StyleElement style = this.createElement(contents);
            this.getHead().insertBefore(style, this.head.getFirstChild());
            return style;
        }

        public void setContents(StyleElement style, String contents) {
            style.setInnerText(contents);
        }

        private StyleElement createElement(String contents) {
            StyleElement style = Document.get().createStyleElement();
            style.setPropertyString("language", "text/css");
            this.setContents(style, contents);
            return style;
        }

        private HeadElement getHead() {
            if (this.head == null) {
                Element elt = Document.get().getElementsByTagName("head").getItem(0);
                assert (elt != null) : "The host HTML page does not have a <head> element which is required by StyleInjector";
                this.head = HeadElement.as(elt);
            }
            return this.head;
        }
    }
}

