/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands.scan;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.capybara.clamav.CommunicationException;
import xyz.capybara.clamav.commands.Command;
import xyz.capybara.clamav.commands.scan.ScanCommand;
import xyz.capybara.clamav.commands.scan.result.ScanResult;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lxyz/capybara/clamav/commands/scan/InStream;", "Lxyz/capybara/clamav/commands/scan/ScanCommand;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "commandString", "", "getCommandString", "()Ljava/lang/String;", "format", "Lxyz/capybara/clamav/commands/Command$CommandFormat;", "getFormat", "()Lxyz/capybara/clamav/commands/Command$CommandFormat;", "send", "Lxyz/capybara/clamav/commands/scan/result/ScanResult;", "server", "Ljava/net/InetSocketAddress;", "Companion", "clamav-client"})
public final class InStream
extends ScanCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream inputStream;
    private static final int CHUNK_SIZE = 2048;

    public InStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.inputStream = inputStream;
    }

    @Override
    @NotNull
    public String getCommandString() {
        return "INSTREAM";
    }

    @Override
    @NotNull
    protected Command.CommandFormat getFormat() {
        return Command.CommandFormat.NULL_CHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ScanResult send(@NotNull InetSocketAddress server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        try {
            Closeable closeable = SocketChannel.open(server);
            Throwable throwable = null;
            try {
                SocketChannel it = (SocketChannel)closeable;
                boolean bl = false;
                it.write(this.getRawCommand());
                ByteBuffer length = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
                byte[] data = new byte[2048];
                int chunkSize = 2048;
                while (chunkSize != -1) {
                    chunkSize = this.inputStream.read(data);
                    if (chunkSize <= 0) continue;
                    ByteBuffer byteBuffer = length;
                    if (byteBuffer == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                    }
                    ((Buffer)byteBuffer).clear();
                    ByteBuffer byteBuffer2 = length.putInt(chunkSize);
                    if (byteBuffer2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                    }
                    ((Buffer)byteBuffer2).flip();
                    it.write(length);
                    it.write(ByteBuffer.wrap(data, 0, chunkSize));
                }
                ByteBuffer byteBuffer = length;
                if (byteBuffer == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                }
                ((Buffer)byteBuffer).clear();
                ByteBuffer byteBuffer3 = length.putInt(0);
                if (byteBuffer3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                }
                ((Buffer)byteBuffer3).flip();
                it.write(length);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                ScanResult scanResult = (ScanResult)this.readResponse(it);
                return scanResult;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lxyz/capybara/clamav/commands/scan/InStream$Companion;", "", "()V", "CHUNK_SIZE", "", "clamav-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

