/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

public final class ParameterizedTypeName
extends TypeName {
    public final ClassName rawType;
    public final List<TypeName> typeArguments;

    ParameterizedTypeName(ClassName rawType, List<TypeName> typeArguments) {
        this.rawType = Util.checkNotNull(rawType, "rawType == null", new Object[0]);
        this.typeArguments = Util.immutableList(typeArguments);
        Util.checkArgument(!this.typeArguments.isEmpty(), "no type arguments: %s", rawType);
        for (TypeName typeArgument : this.typeArguments) {
            Util.checkArgument(!typeArgument.isPrimitive() && typeArgument != VOID, "invalid type parameter: %s", typeArgument);
        }
    }

    public boolean equals(Object o) {
        return o instanceof ParameterizedTypeName && ((ParameterizedTypeName)o).rawType.equals(this.rawType) && ((ParameterizedTypeName)o).typeArguments.equals(this.typeArguments);
    }

    public int hashCode() {
        return this.rawType.hashCode() + 31 * this.typeArguments.hashCode();
    }

    @Override
    CodeWriter emit(CodeWriter out) throws IOException {
        this.rawType.emit(out);
        out.emitAndIndent("<");
        boolean firstParameter = true;
        for (TypeName parameter : this.typeArguments) {
            if (!firstParameter) {
                out.emitAndIndent(", ");
            }
            parameter.emit(out);
            firstParameter = false;
        }
        return out.emitAndIndent(">");
    }

    public static ParameterizedTypeName get(ClassName rawType, TypeName ... typeArguments) {
        return new ParameterizedTypeName(rawType, Arrays.asList(typeArguments));
    }

    public static ParameterizedTypeName get(Class<?> rawType, Type ... typeArguments) {
        return new ParameterizedTypeName(ClassName.get(rawType), ParameterizedTypeName.list(typeArguments));
    }

    public static ParameterizedTypeName get(ParameterizedType type) {
        return new ParameterizedTypeName(ClassName.get((Class)type.getRawType()), TypeName.list(type.getActualTypeArguments()));
    }
}

